/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.runtime;

import java.util.List;
import java.util.Map;
import org.openl.binding.impl.ControlSignal;
import org.openl.rules.tbasic.runtime.AlgorithmErrorHelper;
import org.openl.rules.tbasic.runtime.OpenLAlgorithmErrorSignal;
import org.openl.rules.tbasic.runtime.OpenLAlgorithmGoToMainSignal;
import org.openl.rules.tbasic.runtime.Result;
import org.openl.rules.tbasic.runtime.ReturnType;
import org.openl.rules.tbasic.runtime.TBasicContextHolderEnv;
import org.openl.rules.tbasic.runtime.TBasicVMDataContext;
import org.openl.rules.tbasic.runtime.operations.RuntimeOperation;
import org.openl.types.IOpenClass;
import org.openl.types.Invokable;
import org.openl.types.java.JavaOpenClass;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.Tracer;

public class TBasicVM {
    private TBasicVMDataContext mainContext;
    private TBasicVMDataContext currentContext;
    private IOpenClass tbasicType;

    public TBasicVM(IOpenClass tbasicType, List<RuntimeOperation> operations, Map<String, RuntimeOperation> labels) {
        this.tbasicType = tbasicType;
        this.currentContext = this.mainContext = new TBasicVMDataContext(operations, labels, true);
    }

    private RuntimeOperation getLabeledOperation(String label) {
        if (this.currentContext.isLabelInContext(label)) {
            return this.currentContext.getLabeledOperation(label);
        }
        if (this.mainContext.isLabelInContext(label)) {
            this.goToLabelInMainContext(label);
        }
        throw new RuntimeException(String.format("Unexpected error while execution of TBasic component: unknown label \"%s\"", label));
    }

    private void goToLabelInMainContext(String label) {
        throw new OpenLAlgorithmGoToMainSignal(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run(List<RuntimeOperation> methodSteps, Map<String, RuntimeOperation> methodLabels, TBasicContextHolderEnv environment) {
        TBasicVMDataContext methodContext = new TBasicVMDataContext(methodSteps, methodLabels, false);
        TBasicVMDataContext previousContext = this.swapContext(methodContext);
        try {
            Object object = this.run(environment);
            return object;
        }
        finally {
            this.swapContext(previousContext);
        }
    }

    public Object run(TBasicContextHolderEnv environment) {
        Object returnResult;
        assert (environment != null);
        boolean errorOccured = false;
        try {
            returnResult = this.runAll(environment);
        }
        catch (OpenLAlgorithmErrorSignal signal) {
            if (this.currentContext.isMainMethodContext()) {
                returnResult = AlgorithmErrorHelper.processError(signal.getCause(), environment);
                errorOccured = true;
            }
            throw signal;
        }
        catch (ControlSignal signal) {
            throw signal;
        }
        catch (Throwable error) {
            if (this.currentContext.isMainMethodContext()) {
                returnResult = AlgorithmErrorHelper.processError(error, environment);
                errorOccured = true;
            }
            throw new OpenLAlgorithmErrorSignal(error);
        }
        if (this.tbasicType.equals(JavaOpenClass.VOID) && !errorOccured) {
            returnResult = null;
        }
        return returnResult;
    }

    private Object runAll(TBasicContextHolderEnv environment) {
        RuntimeOperation operation = this.currentContext.getFirstOperation();
        Object previousStepResult = null;
        Object returnResult = null;
        while (operation != null) {
            Result operationResult;
            try {
                operationResult = (Result)Tracer.invoke((Invokable)operation, null, (Object[])new Object[]{previousStepResult}, (IRuntimeEnv)environment, (Object)this);
            }
            catch (OpenLAlgorithmGoToMainSignal signal) {
                operation = this.getLabeledOperation(signal.getLabel());
                continue;
            }
            if (operationResult.getReturnType() == ReturnType.GOTO) {
                assert (operationResult.getValue() instanceof String);
                operation = this.getLabeledOperation((String)operationResult.getValue());
                continue;
            }
            if (operationResult.getReturnType() == ReturnType.RETURN) {
                returnResult = operationResult.getValue();
                break;
            }
            operation = this.currentContext.getNextOperation(operation);
            previousStepResult = operationResult.getValue();
            if (previousStepResult == null) continue;
            returnResult = previousStepResult;
        }
        return returnResult;
    }

    private TBasicVMDataContext swapContext(TBasicVMDataContext newContext) {
        TBasicVMDataContext oldValue = this.currentContext;
        this.currentContext = newContext;
        return oldValue;
    }
}

