/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessages;
import org.openl.rules.data.DataNodeBinder;
import org.openl.rules.data.DataTableBoundNode;
import org.openl.rules.data.ITable;
import org.openl.rules.lang.xls.binding.ATableBoundNode;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.testmethod.TestMethodBoundNode;
import org.openl.rules.testmethod.TestMethodHelper;
import org.openl.rules.testmethod.TestMethodOpenClass;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.MethodsHelper;

public class TestMethodNodeBinder
extends DataNodeBinder {
    private static final String FORMAT_ERROR_MESSAGE = "Testmethod table format: Testmethod <methodname> <testname>";

    @Override
    protected String getFormatErrorMessage() {
        return FORMAT_ERROR_MESSAGE;
    }

    @Override
    protected ATableBoundNode makeNode(TableSyntaxNode tableSyntaxNode, XlsModuleOpenClass module) {
        return new TestMethodBoundNode(tableSyntaxNode, module);
    }

    @Override
    public IMemberBoundNode preBind(TableSyntaxNode tableSyntaxNode, OpenL openl, IBindingContext bindingContext, XlsModuleOpenClass module) throws Exception {
        if (bindingContext.isExecutionMode()) {
            return null;
        }
        ILogicalTable table = tableSyntaxNode.getTable();
        GridCellSourceCodeModule source = new GridCellSourceCodeModule(table.getSource(), bindingContext);
        IdentifierNode[] parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)source, (String)" \n\r");
        this.checkParsedHeader(parsedHeader, source);
        String typeName = parsedHeader[1].getIdentifier();
        String tableName = parsedHeader[2].getIdentifier();
        IOpenMethod[] testedMethods = MethodsHelper.getMethods((String)typeName, (Collection)module.getMethods());
        IOpenMethodHeader header = TestMethodHelper.makeHeader(tableName, module);
        int i = 0;
        DataTableBoundNode bestCaseTestMethodBoundNode = null;
        IOpenMethod bestCaseOpenMethod = null;
        SyntaxNodeException[] bestCaseErrors = null;
        TestMethodOpenClass bestTestMethodOpenClass = null;
        boolean hasNoErrorBinding = false;
        List messages = OpenLMessages.getCurrentInstance().getMessages();
        for (IOpenMethod testedMethod : testedMethods) {
            OpenLMessages.getCurrentInstance().clear();
            for (OpenLMessage message : messages) {
                OpenLMessages.getCurrentInstance().addMessage(message);
            }
            tableSyntaxNode.crearErrors();
            TestMethodBoundNode testMethodBoundNode = (TestMethodBoundNode)this.makeNode(tableSyntaxNode, module);
            TestSuiteMethod testSuite = new TestSuiteMethod(testedMethod, header, testMethodBoundNode);
            testMethodBoundNode.setTestSuite(testSuite);
            TestMethodOpenClass testMethodOpenClass = new TestMethodOpenClass(tableName, testedMethod);
            if (testMethodOpenClass.getInstanceClass() == null) {
                String message = String.format("Type '%s' was defined with errors", typeName);
                throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)parsedHeader[1]);
            }
            try {
                ITable dataTable = this.makeTable(module, tableSyntaxNode, tableName, (IOpenClass)testMethodOpenClass, bindingContext, openl);
                testMethodBoundNode.setTable(dataTable);
                if (testMethodBoundNode.getTableSyntaxNode().hasErrors() && (bestCaseErrors == null || bestCaseErrors.length > testMethodBoundNode.getTableSyntaxNode().getErrors().length)) {
                    bestCaseErrors = testMethodBoundNode.getTableSyntaxNode().getErrors();
                    bestCaseTestMethodBoundNode = testMethodBoundNode;
                    bestCaseOpenMethod = testedMethod;
                    bestTestMethodOpenClass = testMethodOpenClass;
                    continue;
                }
                if (testMethodBoundNode.getTableSyntaxNode().hasErrors()) continue;
                if (hasNoErrorBinding) {
                    ArrayList<IOpenMethod> list = new ArrayList<IOpenMethod>();
                    list.add(testedMethod);
                    list.add(bestCaseOpenMethod);
                    throw new AmbiguousMethodException(tableName, IOpenClass.EMPTY, list);
                }
                bestCaseTestMethodBoundNode = testMethodBoundNode;
                bestCaseOpenMethod = testedMethod;
                bestTestMethodOpenClass = testMethodOpenClass;
                hasNoErrorBinding = true;
                bestCaseErrors = new SyntaxNodeException[]{};
            }
            catch (AmbiguousMethodException e) {
                throw e;
            }
            catch (Exception e) {
                if (i < testedMethods.length - 1) continue;
                throw e;
            }
        }
        if (bestCaseTestMethodBoundNode != null) {
            tableSyntaxNode.crearErrors();
            OpenLMessages.getCurrentInstance().clear();
            for (OpenLMessage message : messages) {
                OpenLMessages.getCurrentInstance().addMessage(message);
            }
            ITable dataTable = this.makeTable(module, tableSyntaxNode, tableName, (IOpenClass)bestTestMethodOpenClass, bindingContext, openl);
            bestCaseTestMethodBoundNode.setTable(dataTable);
            return bestCaseTestMethodBoundNode;
        }
        String message = String.format("Type not found: '%s'", typeName);
        throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)parsedHeader[1]);
    }
}

