/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openl.engine.OpenLSystemProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestSuiteExecutor {
    private static final int QUEUE_SIZE = 2000;
    public static final int DEFAULT_THREAD_COUNT = 4;
    private static volatile TestSuiteExecutor instance;
    private static Map<String, Object> externalParameters;
    private final ThreadPoolExecutor executor;
    private final int threadCount;

    public static void setExternalParameters(Map<String, Object> externalParameters) {
        TestSuiteExecutor.externalParameters = externalParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TestSuiteExecutor getInstance() {
        if (instance != null) return instance;
        Class<TestSuiteExecutor> clazz = TestSuiteExecutor.class;
        synchronized (TestSuiteExecutor.class) {
            if (instance != null) return instance;
            instance = new TestSuiteExecutor(externalParameters);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutDown() {
        Class<TestSuiteExecutor> clazz = TestSuiteExecutor.class;
        synchronized (TestSuiteExecutor.class) {
            if (instance != null) {
                TestSuiteExecutor.instance.executor.shutdownNow();
                instance = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private TestSuiteExecutor(Map<String, Object> externalParameters) {
        ThreadPoolExecutor threadPoolExecutor;
        int testRunThreadCount;
        try {
            testRunThreadCount = OpenLSystemProperties.getTestRunThreadCount(externalParameters);
            threadPoolExecutor = new ThreadPoolExecutor(testRunThreadCount, testRunThreadCount, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(2000), new ThreadPoolExecutor.CallerRunsPolicy());
        }
        catch (Exception e) {
            Logger log = LoggerFactory.getLogger(TestSuiteExecutor.class);
            log.error("Exception while configuring ThreadPoolExecutor. Default thread count will be used.", (Throwable)e);
            testRunThreadCount = 4;
            threadPoolExecutor = new ThreadPoolExecutor(testRunThreadCount, testRunThreadCount, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(2000), new ThreadPoolExecutor.CallerRunsPolicy());
        }
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        this.threadCount = testRunThreadCount;
        this.executor = threadPoolExecutor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public int getThreadCount() {
        return this.threadCount;
    }
}

