/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBoundNode;
import org.openl.rules.binding.RulesBindingDependencies;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.testmethod.TestDescription;
import org.openl.rules.testmethod.TestMethodBoundNode;
import org.openl.rules.testmethod.TestSuite;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.DynamicObject;
import org.openl.vm.IRuntimeEnv;

public class TestSuiteMethod
extends ExecutableRulesMethod {
    private IOpenMethod testedMethod;
    private TestDescription[] tests;
    private Map<String, Integer> indeces;

    public TestSuiteMethod(IOpenMethod testedMethod, IOpenMethodHeader header, TestMethodBoundNode boundNode) {
        super(header, boundNode);
        this.testedMethod = testedMethod;
        this.initProperties(this.getSyntaxNode().getTableProperties());
    }

    protected TestDescription[] initTests() {
        DynamicObject[] testObjects = this.getTestObjects();
        TestDescription[] tests = new TestDescription[testObjects.length];
        this.indeces = new HashMap<String, Integer>(tests.length);
        for (int i = 0; i < tests.length; ++i) {
            tests[i] = new TestDescription(this.getTestedMethod(), testObjects[i], this.getProperties(), this.getBoundNode().getTable().getDataModel().getDescriptor());
            tests[i].setIndex(i);
            this.indeces.put(tests[i].getId(), i);
        }
        return tests;
    }

    public int[] getIndices(String ids) {
        String[] ranges;
        TreeSet<Integer> result = new TreeSet<Integer>();
        for (String range : ranges = ids.trim().split(" *, *")) {
            String[] edges = range.split(" *- *");
            String start = edges[0];
            String end = edges[edges.length - 1];
            int startIndex = this.indeces.get(start);
            int endIndex = this.indeces.get(end);
            for (int i = startIndex; i <= endIndex; ++i) {
                result.add(i);
            }
        }
        Integer[] indices = new Integer[result.size()];
        return ArrayUtils.toPrimitive((Integer[])result.toArray(indices));
    }

    @Override
    public TestMethodBoundNode getBoundNode() {
        return (TestMethodBoundNode)super.getBoundNode();
    }

    public BindingDependencies getDependencies() {
        RulesBindingDependencies bindingDependencies = new RulesBindingDependencies();
        this.updateDependency(bindingDependencies);
        return bindingDependencies;
    }

    private void updateDependency(BindingDependencies bindingDependencies) {
        IOpenMethod testedMethod = this.getTestedMethod();
        if (testedMethod instanceof ExecutableRulesMethod || testedMethod instanceof OpenMethodDispatcher) {
            bindingDependencies.addMethodDependency(testedMethod, (IBoundNode)this.getBoundNode());
        }
    }

    public int getNumberOfTests() {
        return this.getTests().length;
    }

    public String getSourceUrl() {
        return this.getSyntaxNode().getUri();
    }

    public DynamicObject[] getTestObjects() {
        Object testArray = this.getBoundNode().getField().getData();
        return (DynamicObject[])testArray;
    }

    public TestDescription[] getTests() {
        if (this.tests == null) {
            this.tests = this.initTests();
        }
        return this.tests;
    }

    public TestDescription getTest(int numberOfTest) {
        return this.getTests()[numberOfTest];
    }

    public String getColumnDisplayName(String columnTechnicalName) {
        int columnIndex = this.getBoundNode().getTable().getColumnIndex(columnTechnicalName);
        return this.getColumnDisplayName(columnIndex);
    }

    public String getColumnName(int index) {
        if (index >= 0) {
            return this.getBoundNode().getTable().getColumnName(index);
        }
        return null;
    }

    public String getColumnDisplayName(int index) {
        if (index >= 0) {
            return this.getBoundNode().getTable().getColumnDisplay(index);
        }
        return null;
    }

    public int getColumnsCount() {
        return this.getBoundNode().getTable().getNumberOfColumns();
    }

    public IOpenMethod getTestedMethod() {
        return this.testedMethod;
    }

    @Override
    protected boolean isMethodCacheable() {
        return false;
    }

    @Override
    protected TestUnitsResults innerInvoke(Object target, Object[] params, IRuntimeEnv env) {
        return new TestSuite(this).invoke(target, env);
    }

    public boolean isRunmethod() {
        TableSyntaxNode tsn = this.getSyntaxNode();
        return XlsNodeTypes.XLS_RUN_METHOD.toString().equals(tsn.getType());
    }

    public boolean isRunmethodTestable() {
        for (int i = 0; i < this.getNumberOfTests(); ++i) {
            if (!this.getTest(i).isExpectedResultDefined() && !this.getTest(i).isExpectedErrorDefined() && !this.containsFieldsForSprCellTests(this.getTest(i).getTestObject().getFieldValues().keySet()) && !(this.testedMethod instanceof Spreadsheet)) continue;
            return true;
        }
        return false;
    }

    private boolean containsFieldsForSprCellTests(Set<String> fieldNames) {
        for (String fieldName : fieldNames) {
            if (!fieldName.startsWith("$")) continue;
            return true;
        }
        return false;
    }

    public int nUnitRuns() {
        return this.getNumberOfTests();
    }
}

