/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.ArrayList;
import java.util.List;
import org.openl.message.OpenLMessage;
import org.openl.rules.testmethod.ParameterWithValueDeclaration;
import org.openl.rules.testmethod.TestDescription;
import org.openl.rules.testmethod.TestUnitResultComparator;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.testmethod.TestUtils;
import org.openl.rules.testmethod.result.BeanResultComparator;
import org.openl.rules.testmethod.result.ComparedResult;
import org.openl.rules.testmethod.result.TestResultComparator;
import org.openl.rules.testmethod.result.TestResultComparatorFactory;

public class TestUnit {
    private TestDescription test;
    private Object expectedResult;
    private Object actualResult;
    public static final String DEFAULT_DESCRIPTION = "No Description";
    private TestUnitResultComparator testUnitComparator;
    private Integer precision = null;

    public TestUnit(TestDescription test, Object res) {
        this.test = test;
        this.initExpectedResult(test);
        this.actualResult = res;
    }

    private void initExpectedResult(TestDescription test) {
        String expectedError = test.getExpectedError();
        this.expectedResult = expectedError != null ? expectedError : test.getExpectedResult();
    }

    public Object getExpectedResult() {
        return this.expectedResult;
    }

    public Object getActualResult() {
        return this.actualResult;
    }

    public ParameterWithValueDeclaration getActualParam() {
        return new ParameterWithValueDeclaration("actual", this.getActualResult());
    }

    public ParameterWithValueDeclaration[] getContextParams(Object objTestResult) {
        return TestUtils.getContextParams(((TestUnitsResults)objTestResult).getTestSuite(), this.getTest());
    }

    public List<ComparedResult> getResultParams() {
        ArrayList<ComparedResult> params = new ArrayList<ComparedResult>();
        Object actual = this.getActualResult();
        Object expected = this.getExpectedResult();
        TestResultComparator testComparator = this.getTestUnitResultComparator().getComparator();
        if (testComparator instanceof BeanResultComparator && (expected != this.test.getExpectedError() || this.test.getExpectedError() == null)) {
            List<ComparedResult> results = actual instanceof Throwable ? ((BeanResultComparator)testComparator).getExceptionResults((Throwable)actual, expected) : ((BeanResultComparator)testComparator).getComparisonResults();
            for (ComparedResult comparedResult : results) {
                if (!(comparedResult.getActualValue() instanceof ParameterWithValueDeclaration)) {
                    comparedResult.setActualValue(new ParameterWithValueDeclaration(comparedResult.getFieldName(), comparedResult.getActualValue()));
                }
                if (!(comparedResult.getExpectedValue() instanceof ParameterWithValueDeclaration)) {
                    comparedResult.setExpectedValue(new ParameterWithValueDeclaration(comparedResult.getFieldName(), comparedResult.getExpectedValue()));
                }
                params.add(comparedResult);
            }
            return params;
        }
        ComparedResult result = new ComparedResult();
        result.setStatus(TestUnitResultComparator.TestStatus.getConstant(this.compareResult()));
        result.setActualValue(new ParameterWithValueDeclaration("actual", actual));
        result.setExpectedValue(new ParameterWithValueDeclaration("expected", expected));
        params.add(result);
        return params;
    }

    public String getDescription() {
        String descr = this.test.getDescription();
        return descr == null ? DEFAULT_DESCRIPTION : descr;
    }

    public void setTestUnitResultComparator(TestUnitResultComparator testUnitComparator) {
        this.testUnitComparator = testUnitComparator;
    }

    public TestUnitResultComparator getTestUnitResultComparator() {
        if (this.testUnitComparator == null) {
            this.testUnitComparator = new TestUnitResultComparator(TestResultComparatorFactory.getComparator(this.getActualResult(), this.getExpectedResult()));
        }
        return this.testUnitComparator;
    }

    public int compareResult() {
        return this.getTestUnitResultComparator().getCompareResult(this, this.getDelta());
    }

    @Deprecated
    public Object getFieldValue(String fieldName) {
        return this.test.getArgumentValue(fieldName);
    }

    public TestDescription getTest() {
        return this.test;
    }

    public List<OpenLMessage> getResultMessages() {
        return TestUtils.getUserMessagesAndErrors(this.getActualResult());
    }

    public List<OpenLMessage> getErrors() {
        return TestUtils.getErrors(this.getActualResult());
    }

    private Double getDelta() {
        Integer precision;
        Integer n = precision = this.precision != null ? this.precision : this.test.getTestTablePrecision();
        if (precision != null) {
            return Math.pow(10.0, -precision.intValue());
        }
        return null;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }
}

