/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.testmethod.OpenLUserRuntimeException;
import org.openl.rules.testmethod.TestUnit;
import org.openl.rules.testmethod.result.TestResultComparator;

public class TestUnitResultComparator {
    private TestResultComparator resultComparator;
    private Boolean comapreResult = null;

    public TestUnitResultComparator(TestResultComparator resultComparator) {
        this.resultComparator = resultComparator;
    }

    public TestResultComparator getComparator() {
        return this.resultComparator;
    }

    public int getCompareResult(TestUnit testUnit, Double delta) {
        if (testUnit.getActualResult() instanceof Throwable) {
            return this.compareExceptionResult(testUnit, delta);
        }
        if (this.compareResult(testUnit.getActualResult(), testUnit.getExpectedResult(), delta)) {
            return TestStatus.TR_OK.getStatus();
        }
        return TestStatus.TR_NEQ.getStatus();
    }

    public boolean compareResult(Object actualResult, Object expectedResult, Double delta) {
        if (actualResult == expectedResult) {
            return true;
        }
        if (expectedResult == null && (actualResult instanceof Object[] && ((Object[])actualResult).length == 0 || actualResult instanceof Collection && ((Collection)actualResult).isEmpty() || actualResult instanceof Map && ((Map)actualResult).isEmpty() || actualResult instanceof String && ((String)actualResult).isEmpty())) {
            return true;
        }
        if (actualResult == null) {
            return false;
        }
        if (this.comapreResult == null) {
            this.comapreResult = this.resultComparator.compareResult(actualResult, expectedResult, delta);
        }
        return this.comapreResult;
    }

    private int compareExceptionResult(TestUnit testUnit, Double delta) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)((Throwable)testUnit.getActualResult()));
        if (rootCause instanceof OpenLUserRuntimeException) {
            String actualMessage = ((OpenLUserRuntimeException)((Object)rootCause)).getOriginalMessage();
            Object expectedResult = testUnit.getExpectedResult();
            if (expectedResult != null && !(expectedResult instanceof String)) {
                return TestStatus.TR_NEQ.getStatus();
            }
            String expectedMessage = (String)expectedResult;
            if (expectedMessage == null) {
                expectedMessage = "";
            }
            if (expectedMessage.equals(actualMessage)) {
                return TestStatus.TR_OK.getStatus();
            }
            return TestStatus.TR_NEQ.getStatus();
        }
        return TestStatus.TR_EXCEPTION.getStatus();
    }

    public static enum TestStatus {
        TR_EXCEPTION(2),
        TR_NEQ(1),
        TR_OK(0);

        private int status;

        private TestStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public static TestStatus getConstant(int status) {
            switch (status) {
                case 0: {
                    return TR_OK;
                }
                case 1: {
                    return TR_NEQ;
                }
                case 2: {
                    return TR_EXCEPTION;
                }
            }
            throw new OpenlNotCheckedException(String.format("Cant get the constant for compare result for status %d", status));
        }
    }
}

