/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openl.exception.OpenLException;
import org.openl.message.OpenLErrorMessage;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.testmethod.OpenLUserRuntimeException;
import org.openl.rules.testmethod.ParameterWithValueDeclaration;
import org.openl.rules.testmethod.TestDescription;
import org.openl.rules.testmethod.TestSuite;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;

public final class TestUtils {
    public static ParameterWithValueDeclaration[] getContextParams(TestSuite test, TestDescription testCase) {
        ArrayList<ParameterWithValueDeclaration> params = new ArrayList<ParameterWithValueDeclaration>();
        TestSuiteMethod testMethod = test.getTestSuiteMethod();
        IRulesRuntimeContext context = testCase.getRuntimeContext();
        for (int i = 0; i < testMethod.getColumnsCount(); ++i) {
            String columnName = testMethod.getColumnName(i);
            if (columnName == null || !columnName.startsWith("_context_")) continue;
            Object value = context != null ? context.getValue(columnName.replace("_context_.", "")) : null;
            params.add(new ParameterWithValueDeclaration(columnName, value));
        }
        return params.toArray(new ParameterWithValueDeclaration[params.size()]);
    }

    public static List<OpenLMessage> getUserMessagesAndErrors(Object error) {
        if (error instanceof Throwable) {
            Throwable exception = (Throwable)error;
            exception = ExceptionUtils.getRootCause((Throwable)exception);
            ArrayList<OpenLMessage> messages = new ArrayList<OpenLMessage>();
            if (exception instanceof OpenLUserRuntimeException) {
                OpenLUserRuntimeException userException = (OpenLUserRuntimeException)((Object)exception);
                messages.add(new OpenLMessage(userException.getOriginalMessage()));
            } else if (exception instanceof CompositeSyntaxNodeException) {
                CompositeSyntaxNodeException compositeException = (CompositeSyntaxNodeException)exception;
                for (SyntaxNodeException openLException : compositeException.getErrors()) {
                    if (openLException instanceof OpenLUserRuntimeException) {
                        OpenLUserRuntimeException userException = (OpenLUserRuntimeException)((Object)openLException);
                        messages.add(new OpenLMessage(userException.getOriginalMessage()));
                        continue;
                    }
                    messages.add((OpenLMessage)new OpenLErrorMessage((OpenLException)openLException));
                }
            } else if (exception instanceof OpenLException) {
                messages.add((OpenLMessage)new OpenLErrorMessage((OpenLException)exception));
            } else {
                messages.add((OpenLMessage)new OpenLErrorMessage(ExceptionUtils.getRootCauseMessage((Throwable)exception)));
            }
            return messages;
        }
        return Collections.emptyList();
    }

    public static List<OpenLMessage> getErrors(Object error) {
        if (error instanceof Throwable) {
            return OpenLMessagesUtils.newMessages((Throwable)((Throwable)error));
        }
        return Collections.emptyList();
    }
}

