/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.types.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.rules.types.impl.DefaultPropertiesContextMatcher;
import org.openl.rules.types.impl.DefaultPropertiesIntersectionFinder;
import org.openl.rules.types.impl.DefaultTablePropertiesSorter;
import org.openl.rules.types.impl.IPropertiesContextMatcher;
import org.openl.rules.types.impl.MatchingResult;
import org.openl.rules.validation.properties.dimentional.DispatcherTablesBuilder;
import org.openl.runtime.IRuntimeContext;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;

public class MatchingOpenMethodDispatcher
extends OpenMethodDispatcher {
    private static final IPropertiesContextMatcher matcher = new DefaultPropertiesContextMatcher();
    private static final DefaultTablePropertiesSorter prioritySorter = new DefaultTablePropertiesSorter();
    private static final DefaultPropertiesIntersectionFinder intersectionMatcher = new DefaultPropertiesIntersectionFinder();
    private XlsModuleOpenClass moduleOpenClass;
    private List<IOpenMethod> candidatesSorted;
    private IOpenMethod dispatchingOpenMethod;

    public IOpenMethod getDispatchingOpenMethod() {
        return this.dispatchingOpenMethod;
    }

    public void setDispatchingOpenMethod(IOpenMethod dispatchingOpenMethod) {
        this.dispatchingOpenMethod = dispatchingOpenMethod;
    }

    public MatchingOpenMethodDispatcher() {
    }

    public MatchingOpenMethodDispatcher(IOpenMethod method, XlsModuleOpenClass moduleOpenClass) {
        this.decorate(method);
        this.moduleOpenClass = moduleOpenClass;
    }

    @Override
    public IOpenClass getDeclaringClass() {
        return this.moduleOpenClass;
    }

    @Override
    public void addMethod(IOpenMethod candidate) {
        super.addMethod(candidate);
        this.candidatesSorted = null;
    }

    @Override
    protected IOpenMethod findMatchingMethod(List<IOpenMethod> candidates, IRuntimeContext context) {
        HashSet<IOpenMethod> selected = new HashSet<IOpenMethod>(candidates);
        this.selectCandidates(selected, (IRulesRuntimeContext)context);
        this.maxMinSelectCandidates(selected, (IRulesRuntimeContext)context);
        switch (selected.size()) {
            case 0: {
                throw new OpenLRuntimeException(String.format("No matching methods for the context. Details: \n%1$s\nContext: %2$s", this.toString(candidates), context.toString()));
            }
            case 1: {
                IOpenMethod matchingMethod = (IOpenMethod)selected.iterator().next();
                return matchingMethod;
            }
        }
        throw new OpenLRuntimeException(String.format("Ambiguous method dispatch. Details: \n%1$s\nContext: %2$s", this.toString(selected), context.toString()));
    }

    private TableSyntaxNode[] getTableSyntaxNodes() {
        XlsMetaInfo xlsMetaInfo = this.moduleOpenClass.getXlsMetaInfo();
        return xlsMetaInfo.getXlsModuleNode().getXlsTableSyntaxNodes();
    }

    @Override
    public TableSyntaxNode getDispatcherTable() {
        TableSyntaxNode[] tables;
        if (this.dispatchingOpenMethod != null) {
            return (TableSyntaxNode)this.dispatchingOpenMethod.getInfo().getSyntaxNode();
        }
        for (TableSyntaxNode tsn : tables = this.getTableSyntaxNodes()) {
            if (!DispatcherTablesBuilder.isDispatcherTable(tsn) || !tsn.getMember().getName().endsWith(this.getName())) continue;
            return tsn;
        }
        throw new OpenLRuntimeException(String.format("There is no dispatcher table for [%s] method.", this.getName()));
    }

    @Override
    public IMemberMetaInfo getInfo() {
        if (this.getCandidates().size() == 1) {
            return this.getCandidates().get(0).getInfo();
        }
        return this.getDispatcherTable().getMember().getInfo();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void maxMinSelectCandidates(Set<IOpenMethod> selected, IRulesRuntimeContext context) {
        if (selected.size() <= 1) return;
        ArrayList<IOpenMethod> notPriorMethods = new ArrayList<IOpenMethod>();
        List<String> notNullPropertyNames = this.getNotNullPropertyNames(context);
        IOpenMethod mostPriority = null;
        ITableProperties mostPriorityProperties = null;
        Iterator<IOpenMethod> iterator = selected.iterator();
        while (true) {
            boolean contains;
            boolean nested;
            IOpenMethod candidate;
            block14: {
                Iterator<String> iterator2;
                ITableProperties candidateProperties;
                block15: {
                    block13: {
                        if (!iterator.hasNext()) break block13;
                        candidate = iterator.next();
                        if (mostPriority == null) {
                            mostPriority = candidate;
                            mostPriorityProperties = PropertiesHelper.getTableProperties(mostPriority);
                            continue;
                        }
                        nested = false;
                        contains = false;
                        candidateProperties = PropertiesHelper.getTableProperties(candidate);
                        int cmp = this.compareMaxMinPriorities(candidateProperties, mostPriorityProperties);
                        if (cmp < 0) {
                            nested = true;
                            contains = false;
                        } else if (cmp > 0) {
                            nested = false;
                            contains = true;
                        }
                        if (nested || contains) break block14;
                        iterator2 = notNullPropertyNames.iterator();
                        break block15;
                    }
                    selected.removeAll(notPriorMethods);
                    return;
                }
                block7: while (iterator2.hasNext()) {
                    String propName = iterator2.next();
                    switch (intersectionMatcher.match(propName, candidateProperties, mostPriorityProperties)) {
                        case NESTED: {
                            nested = true;
                            break;
                        }
                        case CONTAINS: {
                            contains = true;
                            break;
                        }
                        case EQUALS: {
                            break;
                        }
                        case NO_INTERSECTION: 
                        case PARTLY_INTERSECTS: {
                            nested = false;
                            contains = false;
                            break block7;
                        }
                    }
                }
            }
            if (nested && !contains) {
                notPriorMethods.add(mostPriority);
                mostPriority = candidate;
                mostPriorityProperties = PropertiesHelper.getTableProperties(mostPriority);
                continue;
            }
            if (!contains || nested) continue;
            notPriorMethods.add(candidate);
        }
    }

    private int compareMaxMinPriorities(ITableProperties properties1, ITableProperties properties2) {
        for (Comparator<ITableProperties> comparator : prioritySorter.getMaxMinPriorityRules()) {
            int cmp = comparator.compare(properties1, properties2);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private void selectCandidates(Set<IOpenMethod> selected, IRulesRuntimeContext context) {
        ArrayList<IOpenMethod> nomatched = new ArrayList<IOpenMethod>();
        List<String> notNullPropertyNames = this.getNotNullPropertyNames(context);
        block3: for (IOpenMethod method : selected) {
            ITableProperties props = PropertiesHelper.getTableProperties(method);
            for (String propName : notNullPropertyNames) {
                MatchingResult res = matcher.match(propName, props, context);
                switch (res) {
                    case NO_MATCH: {
                        nomatched.add(method);
                        continue block3;
                    }
                }
            }
        }
        selected.removeAll(nomatched);
    }

    private String toString(Collection<IOpenMethod> methods) {
        StringBuilder builder = new StringBuilder();
        builder.append("Candidates: {\n");
        for (IOpenMethod method : methods) {
            ITableProperties tableProperties = PropertiesHelper.getTableProperties(method);
            builder.append(tableProperties.toString());
            builder.append("\n");
        }
        builder.append("}\n");
        return builder.toString();
    }

    @Override
    public List<IOpenMethod> getCandidates() {
        if (this.candidatesSorted == null) {
            this.candidatesSorted = prioritySorter.sort(super.getCandidates());
        }
        return this.candidatesSorted;
    }

    private List<String> getNotNullPropertyNames(IRulesRuntimeContext context) {
        ArrayList<String> propNames = new ArrayList<String>();
        if (context.getCurrentDate() != null) {
            propNames.add("effectiveDate");
        }
        if (context.getCurrentDate() != null) {
            propNames.add("expirationDate");
        }
        if (context.getRequestDate() != null) {
            propNames.add("startRequestDate");
        }
        if (context.getRequestDate() != null) {
            propNames.add("endRequestDate");
        }
        if (context.getCaRegion() != null) {
            propNames.add("caRegions");
        }
        if (context.getCaProvince() != null) {
            propNames.add("caProvinces");
        }
        if (context.getCountry() != null) {
            propNames.add("country");
        }
        if (context.getRegion() != null) {
            propNames.add("region");
        }
        if (context.getCurrency() != null) {
            propNames.add("currency");
        }
        if (context.getLang() != null) {
            propNames.add("lang");
        }
        if (context.getLob() != null) {
            propNames.add("lob");
        }
        if (context.getUsRegion() != null) {
            propNames.add("usregion");
        }
        if (context.getUsState() != null) {
            propNames.add("state");
        }
        return propNames;
    }
}

