/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.types.impl;

import org.openl.binding.MethodUtil;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.types.impl.MatchingOpenMethodDispatcher;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.vm.IRuntimeEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverloadedMethodsDispatcherTable
extends MatchingOpenMethodDispatcher {
    private final Logger log = LoggerFactory.getLogger(OverloadedMethodsDispatcherTable.class);

    public OverloadedMethodsDispatcherTable() {
    }

    public OverloadedMethodsDispatcherTable(IOpenMethod method, XlsModuleOpenClass moduleOpenClass) {
        super(method, moduleOpenClass);
    }

    @Override
    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        IOpenMethod openMethod = this.getDispatchingOpenMethod();
        if (openMethod != null) {
            return openMethod.invoke(target, this.updateArguments(params, env, openMethod), env);
        }
        this.log.warn("Dispatcher table for methods group [{}] wasn't built correctly. Dispatching will be passed through the java code instead of dispatcher table.", (Object)MethodUtil.printMethod((String)this.getName(), (IOpenClass[])this.getSignature().getParameterTypes()));
        return super.invoke(target, params, env);
    }

    private Object[] updateArguments(Object[] params, IRuntimeEnv env, IOpenMethod dispatcherMethod) {
        IRulesRuntimeContext context;
        Object[] arguments = new Object[dispatcherMethod.getSignature().getNumberOfParameters()];
        int parametersOfOverloadedMethods = this.getCandidates().get(0).getSignature().getNumberOfParameters();
        if (parametersOfOverloadedMethods > 0) {
            System.arraycopy(params, 0, arguments, 0, params.length);
        }
        if ((context = (IRulesRuntimeContext)env.getContext()) != null) {
            for (int i = parametersOfOverloadedMethods; i < dispatcherMethod.getSignature().getNumberOfParameters(); ++i) {
                arguments[i] = context.getValue(dispatcherMethod.getSignature().getParameterName(i));
            }
        }
        return arguments;
    }
}

