/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.OpenL;
import org.openl.exception.OpenLException;
import org.openl.message.OpenLErrorMessage;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLWarnMessage;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.table.properties.DimensionPropertiesMethodKey;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.validation.TablesValidator;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.validation.ValidationResult;
import org.openl.validation.ValidationStatus;
import org.openl.validation.ValidationUtils;

public class ActivePropertyValidator
extends TablesValidator {
    public static final String NO_ACTIVE_TABLE_MESSAGE = "No active table for group of tables. The last version will be used for execution.";
    public static final String ODD_ACTIVE_TABLE_MESSAGE = "There can be only one active table";

    @Override
    public ValidationResult validateTables(OpenL openl, TableSyntaxNode[] tableSyntaxNodes, IOpenClass openClass) {
        ValidationResult validationResult = null;
        Map<DimensionPropertiesMethodKey, List<TableSyntaxNode>> groupedMethods = this.groupExecutableMethods(tableSyntaxNodes);
        for (DimensionPropertiesMethodKey key : groupedMethods.keySet()) {
            List<TableSyntaxNode> methodsGroup = groupedMethods.get(key);
            boolean activeTableWasFound = false;
            for (TableSyntaxNode executableMethodTable : methodsGroup) {
                if (executableMethodTable.getMember() instanceof TestSuiteMethod) {
                    activeTableWasFound = true;
                    break;
                }
                if (executableMethodTable.getTableProperties() == null || !this.isActive(executableMethodTable)) continue;
                if (activeTableWasFound) {
                    if (validationResult == null) {
                        validationResult = new ValidationResult(ValidationStatus.FAIL);
                    }
                    SyntaxNodeException exception = SyntaxNodeExceptionUtils.createError((String)ODD_ACTIVE_TABLE_MESSAGE, (ISyntaxNode)executableMethodTable);
                    executableMethodTable.addError(exception);
                    ValidationUtils.addValidationMessage((ValidationResult)validationResult, (OpenLMessage)new OpenLErrorMessage((OpenLException)exception));
                    continue;
                }
                activeTableWasFound = true;
            }
            if (activeTableWasFound) continue;
            if (validationResult == null) {
                validationResult = new ValidationResult(ValidationStatus.SUCCESS);
            }
            ValidationUtils.addValidationMessage((ValidationResult)validationResult, (OpenLMessage)new OpenLWarnMessage(NO_ACTIVE_TABLE_MESSAGE, (ISyntaxNode)methodsGroup.get(0)));
        }
        if (validationResult != null) {
            return validationResult;
        }
        return ValidationUtils.validationSuccess();
    }

    private boolean isActive(TableSyntaxNode executableMethodTable) {
        return Boolean.TRUE.equals(executableMethodTable.getTableProperties().getActive());
    }

    private Map<DimensionPropertiesMethodKey, List<TableSyntaxNode>> groupExecutableMethods(TableSyntaxNode[] tableSyntaxNodes) {
        HashMap<DimensionPropertiesMethodKey, List<TableSyntaxNode>> groupedMethods = new HashMap<DimensionPropertiesMethodKey, List<TableSyntaxNode>>();
        for (TableSyntaxNode tsn : tableSyntaxNodes) {
            if (!(tsn.getMember() instanceof ExecutableRulesMethod)) continue;
            ExecutableRulesMethod executableMethod = (ExecutableRulesMethod)tsn.getMember();
            DimensionPropertiesMethodKey key = new DimensionPropertiesMethodKey((IOpenMethod)executableMethod);
            if (!groupedMethods.containsKey(key)) {
                groupedMethods.put(key, new ArrayList());
            }
            ((List)groupedMethods.get(key)).add(tsn);
        }
        return groupedMethods;
    }
}

