/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import org.openl.OpenL;
import org.openl.exception.OpenLException;
import org.openl.message.OpenLErrorMessage;
import org.openl.message.OpenLMessage;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.constraints.RegexpValueConstraint;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.table.properties.inherit.PropertiesChecker;
import org.openl.rules.validation.TablesValidator;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.validation.ValidationResult;
import org.openl.validation.ValidationStatus;
import org.openl.validation.ValidationUtils;

public class RegexpPropertyValidator
extends TablesValidator {
    private String propertyName;
    private String constraintsStr;

    public RegexpPropertyValidator(String propertyName, String constraintsStr) {
        this.propertyName = propertyName;
        this.constraintsStr = RegexpValueConstraint.getRegexPattern(constraintsStr);
    }

    @Override
    public ValidationResult validateTables(OpenL openl, TableSyntaxNode[] tableSyntaxNodes, IOpenClass openClass) {
        ValidationResult validationResult = null;
        for (TableSyntaxNode tsn : tableSyntaxNodes) {
            String propertyValue;
            if (!PropertiesChecker.isPropertySuitableForTableType(this.propertyName, tsn.getType()) || tsn.getTableProperties() == null || tsn.getTableProperties().getPropertyLevelDefinedOn(this.propertyName) != InheritanceLevel.TABLE || (propertyValue = (String)tsn.getTableProperties().getPropertyValue(this.propertyName)) != null && propertyValue.matches(this.constraintsStr)) continue;
            if (validationResult == null) {
                validationResult = new ValidationResult(ValidationStatus.FAIL);
            }
            SyntaxNodeException exception = SyntaxNodeExceptionUtils.createError((String)String.format("Incorrect value \"%s\" for property \"%s\"", propertyValue, TablePropertyDefinitionUtils.getPropertyDisplayName(this.propertyName)), (ISyntaxNode)tsn);
            tsn.addError(exception);
            ValidationUtils.addValidationMessage((ValidationResult)validationResult, (OpenLMessage)new OpenLErrorMessage((OpenLException)exception));
        }
        if (validationResult != null) {
            return validationResult;
        }
        return ValidationUtils.validationSuccess();
    }
}

