/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.openl.OpenL;
import org.openl.exception.OpenLException;
import org.openl.message.OpenLErrorMessage;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLWarnMessage;
import org.openl.message.Severity;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.method.ITablePropertiesMethod;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.types.OpenMethodDispatcherHelper;
import org.openl.rules.validation.TablesValidator;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.validation.ValidationResult;
import org.openl.validation.ValidationStatus;
import org.openl.validation.ValidationUtils;

public class UniquePropertyValueValidator
extends TablesValidator {
    private String propertyName;

    public UniquePropertyValueValidator(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public ValidationResult validateTables(OpenL openl, TableSyntaxNode[] tableSyntaxNodes, IOpenClass openClass) {
        ExecutableRulesMethod[] executableActiveMethods = this.selectActiveMethods(OpenMethodDispatcherHelper.extractMethods(openClass.getMethods()));
        HashMap<Object, ExecutableRulesMethod> values = new HashMap<Object, ExecutableRulesMethod>();
        ValidationResult validationResult = null;
        for (ExecutableRulesMethod method : executableActiveMethods) {
            Object value;
            ITableProperties methodProperties = method.getMethodProperties();
            if (methodProperties == null || (value = methodProperties.getPropertyValue(this.propertyName)) == null) continue;
            if (values.containsKey(value)) {
                ExecutableRulesMethod existsMethod = (ExecutableRulesMethod)values.get(value);
                String message = String.format("Found method with duplicate property '%s'", this.propertyName);
                TablePropertyDefinition property = TablePropertyDefinitionUtils.getPropertyByName(this.propertyName);
                Severity errorSeverity = null;
                if (property != null) {
                    errorSeverity = property.getErrorSeverity();
                }
                OpenLMessage message1 = this.getMessage(message, errorSeverity, existsMethod.getSyntaxNode());
                OpenLMessage message2 = this.getMessage(message, errorSeverity, method.getSyntaxNode());
                if (validationResult == null) {
                    validationResult = new ValidationResult(ValidationStatus.FAIL, null);
                    ValidationUtils.addValidationMessage((ValidationResult)validationResult, (OpenLMessage)message1);
                    ValidationUtils.addValidationMessage((ValidationResult)validationResult, (OpenLMessage)message2);
                    continue;
                }
                ValidationUtils.addValidationMessage(validationResult, (OpenLMessage)message2);
                continue;
            }
            values.put(value, method);
        }
        if (validationResult != null) {
            return validationResult;
        }
        return ValidationUtils.validationSuccess();
    }

    private OpenLMessage getMessage(String message, Severity severity, TableSyntaxNode syntaxNode) {
        if (Severity.WARN.equals((Object)severity)) {
            return new OpenLWarnMessage(message, (ISyntaxNode)syntaxNode);
        }
        if (Severity.ERROR.equals((Object)severity)) {
            SyntaxNodeException sne = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)syntaxNode);
            syntaxNode.addError(sne);
            return new OpenLErrorMessage((OpenLException)sne);
        }
        return new OpenLWarnMessage(message, (ISyntaxNode)syntaxNode);
    }

    private ExecutableRulesMethod[] selectActiveMethods(List<IOpenMethod> methods) {
        Collection outputCollection = CollectionUtils.select(methods, (Predicate)new Predicate<IOpenMethod>(){

            public boolean evaluate(IOpenMethod method) {
                if (method instanceof ITablePropertiesMethod) {
                    ITablePropertiesMethod executableMethod = (ITablePropertiesMethod)method;
                    if (executableMethod.getMethodProperties() == null || executableMethod.getMethodProperties().getActive() == null) {
                        return true;
                    }
                    return executableMethod.getMethodProperties().getActive();
                }
                return false;
            }
        });
        return outputCollection.toArray(new ExecutableRulesMethod[outputCollection.size()]);
    }
}

