/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation.properties.dimentional;

import org.apache.commons.lang3.StringUtils;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.expressions.match.MatchingExpression;
import org.openl.rules.validation.properties.dimentional.ADispatcherTableColumn;
import org.openl.rules.validation.properties.dimentional.DispatcherTableRules;

public class ArrayParameterColumn
extends ADispatcherTableColumn {
    private static final String LOGICAL_OR = " || ";

    public ArrayParameterColumn(TablePropertyDefinition arrayDimensionProperty, DispatcherTableRules rules) {
        super(arrayDimensionProperty, rules);
        this.validate();
    }

    private void validate() {
        if (!this.getProperty().getType().getInstanceClass().isArray()) {
            throw new OpenlNotCheckedException("Can`t create array parameter column for not an array property");
        }
    }

    @Override
    public String getCodeExpression() {
        MatchingExpression matchExpression = this.getProperty().getExpression();
        String result = ArrayParameterColumn.getMatchByDefaultCodeExpression(matchExpression);
        StringBuilder codeExpression = new StringBuilder();
        if (matchExpression != null) {
            if (this.getNumberOfLocalParameters() == 1) {
                result = result + this.createCodeExpression(matchExpression, this.getLocalParameterName());
            } else {
                for (int i = 1; i <= this.getNumberOfLocalParameters(); ++i) {
                    if (i > 1) {
                        codeExpression.append(LOGICAL_OR);
                    }
                    String parameterName = (this.getLocalParameterName() + i).intern();
                    codeExpression.append(this.createCodeExpression(matchExpression, parameterName));
                }
                result = result + codeExpression.toString();
            }
        } else {
            String message = String.format("Can`t create expression for \"%s\" property validation.", this.getProperty().getName());
            OpenLMessagesUtils.addWarn((String)message);
        }
        return result.intern();
    }

    @Override
    public String getTitle() {
        return this.getProperty().getDisplayName();
    }

    @Override
    public String getParameterDeclaration() {
        Class<?> componentType = this.getProperty().getType().getInstanceClass().getComponentType();
        String simpleName = componentType.getSimpleName();
        String localParameterName = this.getLocalParameterName();
        return new StringBuilder(64).append(simpleName).append(' ').append(localParameterName).toString().intern();
    }

    @Override
    public String getRuleValue(int ruleIndex, int localParameterIndex) {
        String valuesThroughComma = this.getRules().getRule(ruleIndex).getPropertyValueAsString(this.getProperty().getName());
        String[] values = StringUtils.split((String)valuesThroughComma, (String)",");
        if (values != null && values.length > localParameterIndex) {
            return values[localParameterIndex];
        }
        return null;
    }

    @Override
    public int getNumberOfLocalParameters() {
        int maxNumberOfValues = 0;
        for (int i = 0; i < this.getRules().getRulesNumber(); ++i) {
            int numberOfValues;
            Object[] values = (Object[])this.getRules().getRule(i).getPropertyValue(this.getProperty().getName());
            if (values == null || (numberOfValues = values.length) <= maxNumberOfValues) continue;
            maxNumberOfValues = numberOfValues;
        }
        return maxNumberOfValues;
    }

    private String getLocalParameterName() {
        return (this.getProperty().getName() + "Local").intern();
    }

    private String createCodeExpression(MatchingExpression matchExpression, String parameterName) {
        return matchExpression.getMatchExpression().getCodeExpression(parameterName);
    }
}

