/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation.properties.dimentional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openl.OpenL;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLWarnMessage;
import org.openl.rules.dtx.IDecisionTable;
import org.openl.rules.dtx.type.domains.DimensionPropertiesDomainsCollector;
import org.openl.rules.dtx.type.domains.IDomainAdaptor;
import org.openl.rules.dtx.validator.DecisionTableValidator;
import org.openl.rules.dtx.validator.DesionTableValidationResult;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.ITablePropertiesMethod;
import org.openl.rules.validation.TablesValidator;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.validation.ValidationResult;
import org.openl.validation.ValidationUtils;

public class DimensionPropertiesValidator
extends TablesValidator {
    private static final String VALIDATION_FAILED = "Validation failed for dispatcher table";

    @Override
    public ValidationResult validateTables(OpenL openl, TableSyntaxNode[] tableSyntaxNodes, IOpenClass openClass) {
        Object validationResult = null;
        return ValidationUtils.validationSuccess();
    }

    private OpenLMessage validateDecisionTable(TableSyntaxNode tsn, Map<String, IDomainAdaptor> propertiesDomains, IOpenClass openClass) {
        DesionTableValidationResult tableValidationResult = this.validate(tsn, propertiesDomains, openClass);
        return this.createMessage(tsn, tableValidationResult);
    }

    private DesionTableValidationResult validate(TableSyntaxNode tsn, Map<String, IDomainAdaptor> propertiesDomains, IOpenClass openClass) {
        DesionTableValidationResult tableValidationResult = null;
        try {
            tableValidationResult = DecisionTableValidator.validateTable((IDecisionTable)tsn.getMember(), propertiesDomains, openClass);
        }
        catch (Exception t) {
            throw new OpenlNotCheckedException(VALIDATION_FAILED, (Throwable)t);
        }
        return tableValidationResult;
    }

    private OpenLMessage createMessage(TableSyntaxNode tsn, DesionTableValidationResult tableValidationResult) {
        OpenLWarnMessage validationMessage = null;
        if (tableValidationResult != null && tableValidationResult.hasProblems()) {
            tsn.setValidationResult(tableValidationResult);
            validationMessage = new OpenLWarnMessage(tableValidationResult.toString(), (ISyntaxNode)tsn);
        }
        return validationMessage;
    }

    private boolean isDimensionPropertiesDispatcherTable(TableSyntaxNode tsn) {
        return tsn.getDisplayName() != null && tsn.getDisplayName().contains("validateGapOverlap") && tsn.getMember() instanceof IDecisionTable;
    }

    private Map<String, IDomainAdaptor> getDomainsForDimensionalProperties(List<IOpenMethod> methods) {
        DimensionPropertiesDomainsCollector domainCollector = new DimensionPropertiesDomainsCollector();
        Map<String, IDomainAdaptor> gatheredPropertiesDomains = domainCollector.gatherPropertiesDomains(this.getMethodProperties(methods));
        return gatheredPropertiesDomains;
    }

    private List<Map<String, Object>> getMethodProperties(List<IOpenMethod> methods) {
        ArrayList<Map<String, Object>> properties = new ArrayList<Map<String, Object>>();
        for (IOpenMethod method : methods) {
            if (!(method instanceof ITablePropertiesMethod)) continue;
            properties.add(((ITablePropertiesMethod)method).getProperties());
        }
        return properties;
    }
}

