/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation.properties.dimentional;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.source.impl.VirtualSourceCodeModule;
import org.openl.rules.types.impl.MatchingOpenMethodDispatcher;
import org.openl.rules.validation.properties.dimentional.TableSyntaxNodeDispatcherBuilder;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;

public class DispatcherTablesBuilder {
    public static final String DEFAULT_DISPATCHER_TABLE_NAME = "validateGapOverlap";
    private XlsModuleOpenClass moduleOpenClass;
    private RulesModuleBindingContext moduleContext;

    public static boolean isDispatcherTable(TableSyntaxNode tsn) {
        IOpenMember member = tsn.getMember();
        if (member instanceof IOpenMethod) {
            return member.getName().startsWith(DEFAULT_DISPATCHER_TABLE_NAME);
        }
        return false;
    }

    public DispatcherTablesBuilder(XlsModuleOpenClass moduleOpenClass, RulesModuleBindingContext moduleContext) {
        this.moduleContext = moduleContext;
        this.moduleOpenClass = moduleOpenClass;
    }

    public void build() {
        for (MatchingOpenMethodDispatcher dispatcher : this.getAllMethodDispatchers()) {
            this.build(dispatcher);
        }
    }

    private void build(MatchingOpenMethodDispatcher dispatcher) {
        TableSyntaxNodeDispatcherBuilder tsnDispatcherBuilder = new TableSyntaxNodeDispatcherBuilder(this.moduleContext, this.moduleOpenClass, dispatcher);
        TableSyntaxNode tsn = (TableSyntaxNode)((Object)tsnDispatcherBuilder.build());
        if (tsn != null) {
            if (!this.isVirtualWorkbook()) {
                this.addNewTsnToTopNode(tsn);
            }
            dispatcher.setDispatchingOpenMethod((IOpenMethod)tsn.getMember());
        }
    }

    private boolean isVirtualWorkbook() {
        return this.moduleOpenClass.getXlsMetaInfo().getXlsModuleNode().getModule() instanceof VirtualSourceCodeModule;
    }

    private void addNewTsnToTopNode(TableSyntaxNode tsn) {
        XlsMetaInfo xlsMetaInfo = this.moduleOpenClass.getXlsMetaInfo();
        xlsMetaInfo.getXlsModuleNode().getWorkbookSyntaxNodes()[0].getWorksheetSyntaxNodes()[0].addNode((ISyntaxNode)tsn);
    }

    private List<MatchingOpenMethodDispatcher> getAllMethodDispatchers() {
        ArrayList<MatchingOpenMethodDispatcher> dispatchers = new ArrayList<MatchingOpenMethodDispatcher>();
        for (IOpenMethod method : this.moduleOpenClass.getMethods()) {
            if (!(method instanceof MatchingOpenMethodDispatcher)) continue;
            dispatchers.add((MatchingOpenMethodDispatcher)method);
        }
        return dispatchers;
    }
}

