/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.vm;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openl.rules.table.OpenLArgumentsCloner;
import org.openl.rules.vm.CacheMode;
import org.openl.rules.vm.ResultNotFoundException;
import org.openl.rules.vm.Storage;
import org.openl.types.IOpenClass;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.SimpleVM;

public class SimpleRulesRuntimeEnv
extends SimpleVM.SimpleRuntimeEnv {
    private volatile boolean methodArgumentsCacheEnable = false;
    private volatile CacheMode cacheMode = CacheMode.READ_ONLY;
    private Storage storage = new Storage();
    private static final OpenLArgumentsCloner cloner = new OpenLArgumentsCloner();
    private volatile boolean ignoreRecalculate = true;
    private volatile boolean originalCalculation = true;
    List<CalculationStep> originalCalculationSteps = new LinkedList<CalculationStep>();
    Iterator<CalculationStep> step;
    private IOpenClass topClass;

    public SimpleRulesRuntimeEnv() {
    }

    public SimpleRulesRuntimeEnv(SimpleVM.SimpleRuntimeEnv env) {
        super(env);
    }

    public SimpleRulesRuntimeEnv(SimpleRulesRuntimeEnv env) {
        super((SimpleVM.SimpleRuntimeEnv)env);
        this.methodArgumentsCacheEnable = env.isMethodArgumentsCacheEnable();
        this.cacheMode = env.getCacheMode();
        this.storage = env.storage;
    }

    public IRuntimeEnv cloneEnvForMT() {
        return new SimpleRulesRuntimeEnv(this);
    }

    public boolean isMethodArgumentsCacheEnable() {
        return this.methodArgumentsCacheEnable;
    }

    public void changeMethodArgumentsCache(CacheMode mode) {
        this.cacheMode = mode;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setMethodArgumentsCacheEnable(boolean enable) {
        this.methodArgumentsCacheEnable = enable;
    }

    public void resetMethodArgumentsCache() {
        this.storage.clear();
    }

    public Object findInCache(Object member, Object ... params) throws ResultNotFoundException {
        Data data = this.storage.get(member);
        if (data != null) {
            return data.get(params);
        }
        throw new ResultNotFoundException();
    }

    public void putToCache(Object member, Object[] params, Object result) {
        if (!CacheMode.READ_WRITE.equals((Object)this.getCacheMode())) {
            return;
        }
        Data data = this.storage.get(member);
        if (data == null) {
            data = new Data();
            this.storage.put(member, data);
        }
        try {
            data.get(params);
        }
        catch (ResultNotFoundException e) {
            Object[] clonedParams = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                clonedParams[i] = cloner.deepClone(params[i]);
            }
            data.add(new InvocationData(clonedParams, result));
        }
    }

    public boolean isIgnoreRecalculation() {
        return this.ignoreRecalculate;
    }

    public void setIgnoreRecalculate(boolean ignoreRecalculate) {
        this.ignoreRecalculate = ignoreRecalculate;
    }

    public boolean isOriginalCalculation() {
        return this.originalCalculation;
    }

    public void setOriginalCalculation(boolean originalCalculation) {
        this.originalCalculation = originalCalculation;
    }

    public void resetOriginalCalculationSteps() {
        this.originalCalculationSteps.clear();
        this.initCurrentStep();
    }

    public void registerForwardOriginalCalculationStep(Object member) {
        if (!this.isIgnoreRecalculation() && this.isOriginalCalculation()) {
            this.originalCalculationSteps.add(new ForwardCalculationStep(member));
        }
    }

    public void initCurrentStep() {
        this.step = this.originalCalculationSteps.iterator();
    }

    public void registerBackwardOriginalCalculationStep(Object member, Object result) {
        if (!this.isIgnoreRecalculation() && this.isOriginalCalculation()) {
            this.originalCalculationSteps.add(new BackwardCalculationStep(member, result));
        }
    }

    public boolean registerForwardStep(Object member) {
        if (!this.isIgnoreRecalculation() && !this.isOriginalCalculation()) {
            if (this.step.hasNext()) {
                CalculationStep calculationStep = this.step.next();
                return calculationStep.member == member && calculationStep instanceof ForwardCalculationStep;
            }
            return false;
        }
        return false;
    }

    public Object getResultFromOriginalCalculation(Object member) {
        if (!this.isIgnoreRecalculation() && !this.isOriginalCalculation()) {
            boolean flag = true;
            int level = 0;
            while (flag) {
                CalculationStep calculationStep;
                flag = this.step.hasNext();
                if (!flag || (calculationStep = this.step.next()).getMember() != member) continue;
                if (calculationStep instanceof ForwardCalculationStep) {
                    ++level;
                    continue;
                }
                if (level == 0) {
                    BackwardCalculationStep backwardCalculationStep = (BackwardCalculationStep)calculationStep;
                    return backwardCalculationStep.getResult();
                }
                --level;
            }
            throw new IllegalStateException("Can't find result. Something wrong!!!");
        }
        throw new IllegalStateException("Can't use this method.");
    }

    public void registerBackwardStep(Object member) {
        if (!this.isIgnoreRecalculation() && !this.isOriginalCalculation()) {
            boolean flag = true;
            int level = 0;
            while (flag) {
                CalculationStep calculationStep;
                flag = this.step.hasNext();
                if (!flag || (calculationStep = this.step.next()).getMember() != member) continue;
                if (calculationStep instanceof ForwardCalculationStep) {
                    ++level;
                    continue;
                }
                if (level == 0) {
                    return;
                }
                --level;
            }
        }
    }

    public IOpenClass getTopClass() {
        return this.topClass;
    }

    public void setTopClass(IOpenClass topClass) {
        this.topClass = topClass;
    }

    private static class BackwardCalculationStep
    extends CalculationStep {
        private Object result;

        public BackwardCalculationStep(Object member, Object result) {
            super(member);
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }
    }

    private static class ForwardCalculationStep
    extends CalculationStep {
        public ForwardCalculationStep(Object member) {
            super(member);
        }
    }

    private static abstract class CalculationStep {
        private Object member;

        public CalculationStep(Object member) {
            if (member == null) {
                throw new IllegalArgumentException("Member can't be null");
            }
            this.member = member;
        }

        public Object getMember() {
            return this.member;
        }
    }

    static final class Data {
        private static final int MAX_DATA_LENGTH = 1000;
        InvocationData[] invocationDatas = new InvocationData[1000];
        int size = 0;

        Data() {
        }

        public Object get(Object[] params) throws ResultNotFoundException {
            HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
            hashCodeBuilder.append(params);
            int hashCode = hashCodeBuilder.toHashCode();
            for (int i = 0; i < this.size; ++i) {
                InvocationData invocationData = this.invocationDatas[i];
                if (hashCode != invocationData.getParamsHashCode()) continue;
                EqualsBuilder equalsBuilder = new EqualsBuilder();
                equalsBuilder.append(invocationData.getParams(), params);
                if (!equalsBuilder.isEquals()) continue;
                return invocationData.getResult();
            }
            throw new ResultNotFoundException();
        }

        public void add(InvocationData invocationData) {
            if (this.size < 1000) {
                this.invocationDatas[this.size] = invocationData;
                ++this.size;
            }
        }
    }

    static final class InvocationData {
        private Object[] params;
        private int paramsHashCode;
        private boolean paramsHashCodeCalculated = false;
        private Object result;

        public InvocationData(Object[] params, Object result) {
            this.params = params;
            this.result = result;
        }

        public Object[] getParams() {
            return this.params;
        }

        public int getParamsHashCode() {
            if (!this.paramsHashCodeCalculated) {
                HashCodeBuilder builder = new HashCodeBuilder();
                builder.append(this.getParams());
                this.paramsHashCodeCalculated = true;
                this.paramsHashCode = builder.toHashCode();
            }
            return this.paramsHashCode;
        }

        public Object getResult() {
            return this.result;
        }
    }
}

