/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.ConstrainerObjectImpl;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.FloatExpConst;
import org.openl.ie.constrainer.impl.FloatExpAddArray;
import org.openl.ie.tools.FastVector;

public final class FloatExpArray
extends ConstrainerObjectImpl {
    private FloatExp[] _data;

    public FloatExpArray(Constrainer c, FastVector v) {
        this(c, v.size());
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = (FloatExp)v.elementAt(i);
        }
    }

    public FloatExpArray(Constrainer c, FloatExp e0) {
        this(c, 1);
        this._data[0] = e0;
    }

    public FloatExpArray(Constrainer c, FloatExp e0, FloatExp e1) {
        this(c, 2);
        this._data[0] = e0;
        this._data[1] = e1;
    }

    public FloatExpArray(Constrainer c, FloatExp e0, FloatExp e1, FloatExp e2) {
        this(c, 3);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
    }

    public FloatExpArray(Constrainer c, FloatExp e0, FloatExp e1, FloatExp e2, FloatExp e3) {
        this(c, 4);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
    }

    public FloatExpArray(Constrainer c, FloatExp e0, FloatExp e1, FloatExp e2, FloatExp e3, FloatExp e4) {
        this(c, 5);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
    }

    public FloatExpArray(Constrainer c, FloatExp e0, FloatExp e1, FloatExp e2, FloatExp e3, FloatExp e4, FloatExp e5) {
        this(c, 6);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
        this._data[5] = e5;
    }

    public FloatExpArray(Constrainer c, FloatExp e0, FloatExp e1, FloatExp e2, FloatExp e3, FloatExp e4, FloatExp e5, FloatExp e6) {
        this(c, 7);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
        this._data[5] = e5;
        this._data[6] = e6;
    }

    public FloatExpArray(Constrainer c, FloatExp e0, FloatExp e1, FloatExp e2, FloatExp e3, FloatExp e4, FloatExp e5, FloatExp e6, FloatExp e7) {
        this(c, 8);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
        this._data[5] = e5;
        this._data[6] = e6;
        this._data[7] = e7;
    }

    public FloatExpArray(Constrainer c, FloatExp e0, FloatExp e1, FloatExp e2, FloatExp e3, FloatExp e4, FloatExp e5, FloatExp e6, FloatExp e7, FloatExp e8) {
        this(c, 9);
        this._data[0] = e0;
        this._data[1] = e1;
        this._data[2] = e2;
        this._data[3] = e3;
        this._data[4] = e4;
        this._data[5] = e5;
        this._data[6] = e6;
        this._data[7] = e7;
        this._data[8] = e8;
    }

    public FloatExpArray(Constrainer c, int size) {
        super(c);
        this._data = new FloatExp[size];
    }

    public FloatExpArray(Constrainer c, Vector v) {
        this(c, v.size());
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = (FloatExp)v.elementAt(i);
        }
    }

    FloatExpArray(FloatExpArray ary, int indexStart, int size) {
        this(ary.constrainer(), size);
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = ary._data[indexStart + i];
        }
    }

    public FloatExp[] data() {
        return this._data;
    }

    public FloatExp elementAt(int idx) {
        return this._data[idx];
    }

    public FloatExp get(int idx) {
        return this._data[idx];
    }

    public double max() {
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this._data.length; ++i) {
            double maxi = this._data[i].max();
            if (!(maxi > max)) continue;
            max = maxi;
        }
        return max;
    }

    public double min() {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this._data.length; ++i) {
            double mini = this._data[i].min();
            if (!(mini < min)) continue;
            min = mini;
        }
        return min;
    }

    @Override
    public void name(String name) {
        this.symbolicName(name);
    }

    public void set(FloatExp exp, int idx) {
        this._data[idx] = exp;
    }

    public int size() {
        return this._data.length;
    }

    public void sort(Comparator c) {
        Arrays.sort(this._data, c);
    }

    public FloatExp sum() {
        return this.sumAsTree();
    }

    FloatExp sumAsAddArray() {
        switch (this.size()) {
            case 0: {
                return (FloatExp)this._constrainer.expressionFactory().getExpression(FloatExpConst.class, new Object[]{this._constrainer, new Double(0.0)});
            }
            case 1: {
                return this._data[0];
            }
            case 2: {
                return this._data[0].add(this._data[1]);
            }
        }
        return (FloatExp)this._constrainer.expressionFactory().getExpression(FloatExpAddArray.class, new Object[]{this._constrainer, this});
    }

    FloatExp sumAsTree() {
        int maxNodeArity = 10;
        int size = this.size();
        if (size <= 10) {
            return this.sumAsAddArray();
        }
        int subSumSize = 10;
        int nSubSums = size / subSumSize;
        int reminder = size % subSumSize;
        if (reminder > 0) {
            ++nSubSums;
        }
        FloatExpArray subSums = new FloatExpArray(this.constrainer(), nSubSums);
        for (int i = 0; i < nSubSums; ++i) {
            int indexStart = i * subSumSize;
            int sz = Math.min(subSumSize, size - indexStart);
            FloatExpArray subSum = new FloatExpArray(this, indexStart, sz);
            subSums.set(subSum.sumAsAddArray(), i);
        }
        return subSums.sumAsTree();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = 0; i < this._data.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(this._data[i]);
        }
        buf.append("]");
        return buf.toString();
    }
}

