/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import org.openl.ie.constrainer.ChoicePointLabel;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalAnd;
import org.openl.ie.constrainer.GoalImpl;
import org.openl.ie.constrainer.GoalOr;
import org.openl.ie.constrainer.impl.ConstraintFloatExpLessValue;
import org.openl.util.Log;

public class GoalFloatFastMinimize
extends GoalImpl {
    private FloatExp _cost;
    private double _best_cost_min;
    private double _best_cost_max;
    private Goal _goal_find_solution;
    private ConstraintFloatExpLessValue _constraint_limit_cost;
    private int _number_of_solutions;
    private boolean _trace;
    private Object _client_tracer;
    private boolean _goal_saves_solution;
    private ChoicePointLabel _rootLabel;
    private double _cost_step;

    public GoalFloatFastMinimize(Goal goal, FloatExp cost, double costStep) {
        super(cost.constrainer(), "");
        this._goal_find_solution = goal;
        this._cost = cost;
        this._constraint_limit_cost = new ConstraintFloatExpLessValue(this._cost, this._cost.max());
        this._number_of_solutions = 0;
        this._trace = false;
        this._client_tracer = null;
        this._goal_saves_solution = false;
        this._rootLabel = this.constrainer().createChoicePointLabel();
        this._cost_step = Math.abs(costStep);
    }

    public void clientTracer(Object tracer) {
        this._client_tracer = tracer;
    }

    @Override
    public Goal execute() throws Failure {
        return new GoalOr(new FindAndImprove(this.constrainer()), new AnalyzeAndSet(this.constrainer()), this._rootLabel);
    }

    public void savesSolutionFlag(boolean flag) {
        this._goal_saves_solution = flag;
    }

    @Override
    public String toString() {
        return "Use " + this._goal_find_solution.name() + " to minimize(" + this._cost.name() + ")";
    }

    public void traceFlag(boolean flag) {
        this._trace = flag;
    }

    class GoalBacktrack
    extends GoalImpl {
        public GoalBacktrack(Constrainer c) {
            super(c, "GoalBacktrack");
        }

        @Override
        public Goal execute() throws Failure {
            this.fixFoundSolution();
            ChoicePointLabel lbl = this.constrainer().currentChoicePointLabel();
            while ((lbl == null || !lbl.equals(GoalFloatFastMinimize.this._rootLabel)) && this.violated()) {
                if (!this.constrainer().backtrack()) {
                    throw new RuntimeException("Internal error in " + this);
                }
                if (!GoalFloatFastMinimize.this._trace) continue;
                Log.info((Object)(" Backtrack: cost" + GoalFloatFastMinimize.this._cost.domainToString() + " best_cost_min=" + GoalFloatFastMinimize.this._best_cost_min));
            }
            if (this.violated()) {
                this.constrainer().fail("GoalBacktrack");
            }
            GoalFloatFastMinimize.this._constraint_limit_cost.resetValue(GoalFloatFastMinimize.this._best_cost_min - GoalFloatFastMinimize.this._cost_step);
            return null;
        }

        void fixFoundSolution() {
            GoalFloatFastMinimize.this._best_cost_min = GoalFloatFastMinimize.this._cost.min();
            GoalFloatFastMinimize.this._best_cost_max = GoalFloatFastMinimize.this._cost.max();
            GoalFloatFastMinimize.this._number_of_solutions++;
            if (GoalFloatFastMinimize.this._trace) {
                Log.info((Object)("Solution " + GoalFloatFastMinimize.this._number_of_solutions + ": cost" + GoalFloatFastMinimize.this._cost.domainToString()));
            }
            if (GoalFloatFastMinimize.this._client_tracer != null) {
                Log.info((Object)GoalFloatFastMinimize.this._client_tracer.toString());
            }
        }

        boolean violated() {
            return GoalFloatFastMinimize.this._cost.min() > GoalFloatFastMinimize.this._best_cost_min - GoalFloatFastMinimize.this._cost_step;
        }
    }

    class FindAndImprove
    extends GoalImpl {
        FindAndImprove(Constrainer C) {
            super(C, "FindAndImprove");
        }

        @Override
        public Goal execute() throws Failure {
            GoalFloatFastMinimize.this._constraint_limit_cost.resetValue(GoalFloatFastMinimize.this._cost.max());
            GoalFloatFastMinimize.this._constraint_limit_cost.post();
            return new GoalAnd(GoalFloatFastMinimize.this._goal_find_solution, new GoalBacktrack(this.constrainer()));
        }
    }

    class AnalyzeAndSet
    extends GoalImpl {
        AnalyzeAndSet(Constrainer C) {
            super(C, "AnalyzeAndSet");
        }

        @Override
        public Goal execute() throws Failure {
            if (GoalFloatFastMinimize.this._number_of_solutions <= 0) {
                this.constrainer().fail();
            }
            if (GoalFloatFastMinimize.this._goal_saves_solution) {
                return null;
            }
            double eps = 1.0E-6;
            double search_cost_min = GoalFloatFastMinimize.this._best_cost_min - eps;
            double search_cost_max = GoalFloatFastMinimize.this._best_cost_max + eps;
            GoalFloatFastMinimize.this._cost.moreOrEqual(search_cost_min).post();
            GoalFloatFastMinimize.this._cost.lessOrEqual(search_cost_max).post();
            return GoalFloatFastMinimize.this._goal_find_solution;
        }
    }
}

