/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import java.util.HashMap;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.constrainer.impl.IntExpAddArray;
import org.openl.ie.constrainer.impl.IntExpCard;

public final class IntArrayCards
extends Observer {
    int _min;
    int _max;
    IntExpArray _vars;
    IntExpArray _cards;
    HashMap _index_map = new HashMap();

    public IntArrayCards(Constrainer constrainer, IntExpArray vars) throws Failure {
        this._vars = vars;
        this._min = vars.min();
        this._max = vars.max();
        IntExp[] var_data = vars.data();
        for (int i = 0; i < var_data.length; ++i) {
            var_data[i].attachObserver(this);
            this._index_map.put(var_data[i], new Integer(i));
        }
        int size = Math.max(1, this._max - this._min + 1);
        this._cards = new IntExpArray(constrainer, size);
        for (int i = 0; i < size; ++i) {
            this._cards.set(new IntExpCard(constrainer, this._vars, this._min + i), i);
        }
        new IntExpAddArray(constrainer, this._cards).equals(vars.size()).execute();
    }

    public IntExpCard cardAt(int i) {
        return (IntExpCard)this._cards.get(i - this._min);
    }

    public IntExpArray cards() {
        return this._cards;
    }

    public int cardSize() {
        return this._cards.size();
    }

    int getIndex(IntExp exp) {
        return (Integer)this._index_map.get(exp);
    }

    @Override
    public Object master() {
        return null;
    }

    @Override
    public int subscriberMask() {
        return 15;
    }

    public String toString() {
        return "" + this._cards + " card for " + this._vars;
    }

    @Override
    public void update(Subject subject, EventOfInterest event) throws Failure {
        int i;
        IntEvent e = (IntEvent)event;
        IntExp[] cards = this._cards.data();
        int var_index = this.getIndex(e.exp());
        int type = e.type();
        int max = e.max();
        int min = e.min();
        if ((type & 2) != 0) {
            int oldmin;
            for (i = oldmin = e.oldmin(); i < min; ++i) {
                ((IntExpCard)cards[i - this._min]).removeIndex(var_index);
            }
        }
        if ((type & 4) != 0) {
            int oldmax;
            for (i = oldmax = e.oldmax(); i > max; --i) {
                ((IntExpCard)cards[i - this._min]).removeIndex(var_index);
            }
        }
        if ((type & 8) != 0) {
            int nRemoves = e.numberOfRemoves();
            for (i = 0; i < nRemoves; ++i) {
                int removed = e.removed(i);
                if (min >= removed || removed >= max) continue;
                ((IntExpCard)cards[removed - this._min]).removeIndex(var_index);
            }
        }
        if ((type & 1) != 0) {
            ((IntExpCard)cards[min - this._min]).addValueIndex(var_index);
        }
    }
}

