/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.consistencyChecking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalAnd;
import org.openl.ie.constrainer.GoalGenerate;
import org.openl.ie.constrainer.GoalImpl;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.IntBoolExpConst;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.consistencyChecking.CDecisionTable;
import org.openl.ie.constrainer.consistencyChecking.CompletenessChecker;
import org.openl.ie.constrainer.consistencyChecking.DTChecker;
import org.openl.ie.constrainer.consistencyChecking.Overlapping;
import org.openl.ie.constrainer.consistencyChecking.OverlappingChecker;
import org.openl.ie.constrainer.consistencyChecking.OverlappingCheckerImpl2;
import org.openl.ie.constrainer.consistencyChecking.Uncovered;

public class DTCheckerImpl
implements DTChecker {
    private CDecisionTable _dt = null;
    private CompletenessChecker _cpChecker = new CompletenessCheckerImpl();
    private OverlappingChecker _opChecker;
    private List<Uncovered> _uncoveredRegions = new ArrayList<Uncovered>();
    private List<Overlapping> _overlappingRules = new ArrayList<Overlapping>();

    public DTCheckerImpl(CDecisionTable dtable) {
        this._dt = dtable;
        this._opChecker = new OverlappingCheckerImpl2(this._dt);
    }

    @Override
    public List<Uncovered> checkCompleteness() {
        return this._cpChecker.check();
    }

    @Override
    public List<Overlapping> checkOverlappings() {
        return this._opChecker.check();
    }

    @Override
    public CompletenessChecker getCompletenessChecker() {
        return this._cpChecker;
    }

    @Override
    public CDecisionTable getDT() {
        return this._dt;
    }

    @Override
    public OverlappingChecker getOverlappingChecker() {
        return this._opChecker;
    }

    @Override
    public void setCompletenessChecker(CompletenessChecker chk) {
        this._cpChecker = chk;
    }

    @Override
    public void setDT(CDecisionTable dtable) {
        this._dt = dtable;
    }

    @Override
    public void setOverlappingChecker(OverlappingChecker chk) {
        this._opChecker = chk;
    }

    private class CompletenessCheckerImpl
    implements CompletenessChecker {
        private Constrainer C = null;

        private CompletenessCheckerImpl() {
        }

        @Override
        public List<Uncovered> check() {
            IntBoolExp[] rules = DTCheckerImpl.this._dt.getRules();
            this.C = rules[0].constrainer();
            IntExpArray ruleArray = new IntExpArray(this.C, rules.length);
            for (int i = 0; i < rules.length; ++i) {
                ruleArray.set(rules[i], i);
            }
            Constraint incompleteness = ruleArray.sum().equals(0);
            GoalSaveSolutions save = new GoalSaveSolutions(this.C);
            GoalGenerate generate = new GoalGenerate(DTCheckerImpl.this._dt.getVars());
            GoalAnd target = new GoalAnd(new GoalAnd(incompleteness, generate), save);
            this.C.execute((Goal)target, true);
            return DTCheckerImpl.this._uncoveredRegions;
        }

        private class GoalSaveSolutions
        extends GoalImpl {
            private static final long serialVersionUID = -4747909482843265994L;

            public GoalSaveSolutions(Constrainer c) {
                super(c);
            }

            @Override
            public Goal execute() throws Failure {
                DTCheckerImpl.this._uncoveredRegions.add(new Uncovered(DTCheckerImpl.this._dt.getVars()));
                return null;
            }
        }
    }

    public static class CDecisionTableImpl
    implements CDecisionTable {
        private IntBoolExp[][] _data = null;
        private IntBoolExp[] _rules = null;
        private IntExpArray _vars = null;
        boolean overrideAscending;

        public CDecisionTableImpl(IntBoolExp[][] data, IntExpArray vars, boolean overrideAscending) {
            if (data == null) {
                throw new IllegalArgumentException("DecisionTableImpl(IntBoolExp[][] _data, IntExpArray vars) : can't be created based on null data array");
            }
            this._data = data;
            this._vars = vars;
            this.overrideAscending = overrideAscending;
            int nbRules = this._data.length;
            this._rules = new IntBoolExp[nbRules];
            Arrays.fill(this._rules, new IntBoolExpConst(this._vars.constrainer(), true));
            for (int i = 0; i < this._data.length; ++i) {
                int nbVars = this._data[i].length;
                for (int j = 0; j < nbVars; ++j) {
                    this._rules[i] = this._rules[i].and(this._data[i][j]);
                }
            }
        }

        @Override
        public IntBoolExp getEntry(int i, int j) {
            return this._data[i][j];
        }

        @Override
        public IntBoolExp getRule(int i) {
            return this._rules[i];
        }

        @Override
        public IntBoolExp[] getRules() {
            return this._rules;
        }

        @Override
        public IntVar getVar(int i) {
            return (IntVar)this._vars.get(i);
        }

        @Override
        public IntExpArray getVars() {
            return this._vars;
        }

        @Override
        public boolean isOverrideAscending() {
            return this.overrideAscending;
        }
    }
}

