/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.ConstraintImpl;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatEvent;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ConstraintFloatExpNotValue;
import org.openl.ie.constrainer.impl.FloatCalc;

public final class ConstraintFloatExpEqualsValue
extends ConstraintImpl {
    private FloatExp _exp;
    private double _value;
    private Constraint _opposite;

    public ConstraintFloatExpEqualsValue(FloatExp exp, double value) {
        super(exp.constrainer());
        this._exp = exp;
        this._value = value;
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + exp.name() + "=" + value + ")";
        }
    }

    @Override
    public Goal execute() throws Failure {
        this._exp.setValue(this._value);
        class ObserverFloatEqualValue
        extends Observer {
            ObserverFloatEqualValue() {
            }

            @Override
            public Object master() {
                return ConstraintFloatExpEqualsValue.this;
            }

            @Override
            public int subscriberMask() {
                return 7;
            }

            public String toString() {
                return "ObserverFloatEqualValue";
            }

            @Override
            public void update(Subject exp, EventOfInterest interest) throws Failure {
                FloatEvent event = (FloatEvent)interest;
                if (FloatCalc.gt(ConstraintFloatExpEqualsValue.this._value, event.max()) || FloatCalc.gt(event.min(), ConstraintFloatExpEqualsValue.this._value)) {
                    exp.constrainer().fail("from ObserverFloatEqualValue");
                }
                ConstraintFloatExpEqualsValue.this._exp.setValue(ConstraintFloatExpEqualsValue.this._value);
            }
        }
        this._exp.attachObserver(new ObserverFloatEqualValue());
        return null;
    }

    @Override
    public boolean isLinear() {
        return this._exp.isLinear();
    }

    @Override
    public Constraint opposite() {
        if (this._opposite == null) {
            this._opposite = new ConstraintFloatExpNotValue(this._exp, this._value);
        }
        return this._opposite;
    }

    @Override
    public IntBoolExp toIntBoolExp() {
        return this._exp.eq(this._value);
    }

    @Override
    public String toString() {
        return this._exp + "=" + this._value;
    }
}

