/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.ConstraintImpl;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatEvent;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ConstraintFloatExpLessValue;
import org.openl.ie.constrainer.impl.FloatCalc;

public final class ConstraintFloatExpMoreValue
extends ConstraintImpl {
    private FloatExp _exp;
    private double _value;
    private Constraint _opposite;

    public ConstraintFloatExpMoreValue(FloatExp exp, double value) {
        super(exp.constrainer(), "");
        this._name = "";
        if (this.constrainer().showInternalNames()) {
            this._name = exp.name() + ">=" + value;
        }
        this._exp = exp;
        this._value = value;
        this._opposite = null;
    }

    @Override
    public Goal execute() throws Failure {
        this._exp.setMin(this._value);
        class ObserverFloatMoreValue
        extends Observer {
            ObserverFloatMoreValue() {
            }

            @Override
            public Object master() {
                return ConstraintFloatExpMoreValue.this;
            }

            @Override
            public int subscriberMask() {
                return 5;
            }

            public String toString() {
                return "ObserverFloatMoreValue";
            }

            @Override
            public void update(Subject exp, EventOfInterest interest) throws Failure {
                FloatEvent event = (FloatEvent)interest;
                if (FloatCalc.gt(ConstraintFloatExpMoreValue.this._value, event.max())) {
                    exp.constrainer().fail("from ObserverFloatMoreValue");
                }
                ConstraintFloatExpMoreValue.this._exp.setMin(ConstraintFloatExpMoreValue.this._value);
            }
        }
        this._exp.attachObserver(new ObserverFloatMoreValue());
        return null;
    }

    @Override
    public boolean isLinear() {
        return this._exp.isLinear();
    }

    @Override
    public Constraint opposite() {
        if (this._opposite == null) {
            this._opposite = new ConstraintFloatExpLessValue(this._exp, this._value);
        }
        return this._opposite;
    }

    @Override
    public IntBoolExp toIntBoolExp() {
        return this._exp.ge(this._value);
    }

    @Override
    public String toString() {
        return this._exp + ">=" + this._value;
    }
}

