/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatEvent;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.FloatExpImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public final class FloatExpAddValue
extends FloatExpImpl {
    private FloatExp _exp;
    private double _value;
    private ExpressionObserver _observer;

    public FloatExpAddValue(FloatExp exp, double value) {
        super(exp.constrainer(), "");
        this._exp = exp;
        this._value = value;
        this._observer = new FloatExpAddValueObserver();
        this._exp.attachObserver(this._observer);
    }

    @Override
    public FloatExp add(double value) {
        return this._exp.add(this._value + value);
    }

    @Override
    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        return this._exp.calcCoeffs(map, factor) + this._value * factor;
    }

    @Override
    public boolean isLinear() {
        return this._exp.isLinear();
    }

    @Override
    public double max() {
        return this._exp.max() + this._value;
    }

    @Override
    public double min() {
        return this._exp.min() + this._value;
    }

    @Override
    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._exp);
    }

    @Override
    public void setMax(double max) throws Failure {
        this._exp.setMax(max - this._value);
    }

    @Override
    public void setMin(double min) throws Failure {
        this._exp.setMin(min - this._value);
    }

    @Override
    public void setValue(double value) throws Failure {
        this._exp.setValue(value - this._value);
    }

    @Override
    public double size() {
        return this._exp.size();
    }

    @Override
    public String toString() {
        return "(" + this._exp + " + " + this._value + ")";
    }

    class FloatExpAddValueObserver
    extends ExpressionObserver {
        FloatExpAddValueObserver() {
        }

        @Override
        public Object master() {
            return FloatExpAddValue.this;
        }

        @Override
        public String toString() {
            return "FloatExpAddValueObserver: " + FloatExpAddValue.this._exp + "+" + FloatExpAddValue.this._value;
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            FloatEvent e = (FloatEvent)event;
            FloatEventAddValue ev = FloatEventAddValue.getEvent(e, FloatExpAddValue.this._value);
            ev.exp(FloatExpAddValue.this);
            FloatExpAddValue.this.notifyObservers(ev);
        }
    }

    static final class FloatEventAddValue
    extends FloatEvent {
        static ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new FloatEventAddValue();
            }
        };
        double _value;
        FloatEvent _event;

        FloatEventAddValue() {
        }

        static FloatEventAddValue getEvent(FloatEvent event, double value) {
            FloatEventAddValue ev = (FloatEventAddValue)_factory.getElement();
            ev.init(event, value);
            return ev;
        }

        public void init(FloatEvent e, double value) {
            this._event = e;
            this._value = value;
        }

        @Override
        public double max() {
            return this._event.max() + this._value;
        }

        @Override
        public double min() {
            return this._event.min() + this._value;
        }

        @Override
        public String name() {
            return "Event FloatAddValue";
        }

        @Override
        public double oldmax() {
            return this._event.oldmax() + this._value;
        }

        @Override
        public double oldmin() {
            return this._event.oldmin() + this._value;
        }

        @Override
        public int type() {
            return this._event.type();
        }
    }
}

