/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.FloatVar;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.FloatExpImpl;

public final class FloatExpPowIntValue
extends FloatExpImpl {
    private static final int[] event_map = new int[]{6, 2, 6, 4, 1, 1, 8, 8};
    private FloatExp _exp;
    private int _value;
    private FloatVar _result;
    private ExpressionObserver _observer;

    static double calc_max(double min, double max, int value) {
        if (value % 2 == 0) {
            return Math.max(Math.pow(min, value), Math.pow(max, value));
        }
        return Math.pow(max, value);
    }

    static double calc_min(double min, double max, int value) {
        if (value % 2 == 0) {
            if (min >= 0.0) {
                return Math.pow(min, value);
            }
            if (max <= 0.0) {
                return Math.pow(max, value);
            }
            return 0.0;
        }
        return Math.pow(min, value);
    }

    public FloatExpPowIntValue(FloatExp exp, int value) {
        super(exp.constrainer(), "");
        this._exp = exp;
        this._value = value;
        this._observer = new FloatExpPowIntValueObserver();
        this._exp.attachObserver(this._observer);
        double min = this._exp.min();
        double max = this._exp.max();
        int trace = 0;
        this._result = this.constrainer().addFloatVarTraceInternal(FloatExpPowIntValue.calc_min(min, max, this._value), FloatExpPowIntValue.calc_max(min, max, this._value), "pow", trace);
    }

    @Override
    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._result.attachObserver(observer);
    }

    @Override
    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        if (this._value != 0 && this._value != 1) {
            throw new NonLinearExpression(this);
        }
        if (this._value == 0) {
            return 1.0;
        }
        return this._exp.calcCoeffs(map, factor);
    }

    @Override
    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._result.detachObserver(observer);
    }

    @Override
    public boolean isLinear() {
        return this._exp.isLinear() && (this._value == 1 || this._value == 0);
    }

    @Override
    public double max() {
        return this._result.max();
    }

    @Override
    public double min() {
        return this._result.min();
    }

    @Override
    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._exp);
    }

    @Override
    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._result.reattachObserver(observer);
    }

    @Override
    public void setMax(double max) throws Failure {
        if (this._value % 2 == 0 && max < 0.0) {
            this.constrainer().fail("pow(exp,value).setMax(): max < 0 for even value");
        }
    }

    @Override
    public void setMin(double min) throws Failure {
        if (this._value % 2 == 0 && min <= 0.0) {
            return;
        }
    }

    @Override
    public void setValue(double value) throws Failure {
        this.setMin(value);
        this.setMax(value);
    }

    @Override
    public String toString() {
        return "pow(" + this._exp + "," + this._value + ")" + this.domainToString();
    }

    class FloatExpPowIntValueObserver
    extends ExpressionObserver {
        FloatExpPowIntValueObserver() {
            super(event_map);
        }

        @Override
        public Object master() {
            return FloatExpPowIntValue.this;
        }

        @Override
        public int subscriberMask() {
            return 7;
        }

        @Override
        public String toString() {
            return "FloatExpPowIntValueObserver: pow(" + FloatExpPowIntValue.this._exp + "," + FloatExpPowIntValue.this._value + ")";
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            double min = FloatExpPowIntValue.this._exp.min();
            double max = FloatExpPowIntValue.this._exp.max();
            FloatExpPowIntValue.this._result.setMin(FloatExpPowIntValue.calc_min(min, max, FloatExpPowIntValue.this._value));
            FloatExpPowIntValue.this._result.setMax(FloatExpPowIntValue.calc_max(min, max, FloatExpPowIntValue.this._value));
        }
    }
}

