/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalAnd;
import org.openl.ie.constrainer.GoalFail;
import org.openl.ie.constrainer.GoalImpl;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.impl.ConstraintExpLessValue;

public class GoalFastMinimizeOld
extends GoalImpl {
    private IntExp _cost;
    private Goal _goal_find_solution;
    private ConstraintExpLessValue _goal_limit_cost;
    private Goal _goal_decrement_cost;
    private Goal _goal_save_cost;
    private Goal _goal_fail;
    private int _saved_cost;
    private int _number_of_solutions;
    private boolean _trace;
    private Object _client_tracer;
    private boolean _goal_saves_solution;

    public GoalFastMinimizeOld(Goal goal, IntExp cost) {
        this(goal, cost, false, false);
    }

    public GoalFastMinimizeOld(Goal goal, IntExp cost, boolean goal_saves_solution) {
        this(goal, cost, false, goal_saves_solution);
    }

    public GoalFastMinimizeOld(Goal goal, IntExp cost, boolean trace, boolean goal_saves_solution) {
        super(cost.constrainer(), "");
        this._goal_find_solution = goal;
        this._cost = cost;
        this._goal_limit_cost = new ConstraintExpLessValue(this._cost, this._cost.max() + 1);
        this._goal_save_cost = new SaveCost(this.constrainer());
        this._goal_decrement_cost = new DecrementCost(this.constrainer());
        this._goal_fail = new GoalFail(this.constrainer());
        this._number_of_solutions = 0;
        this._trace = trace;
        this._client_tracer = null;
        this._goal_saves_solution = goal_saves_solution;
    }

    public GoalFastMinimizeOld(Goal goal, IntExp cost, Object tracer) {
        this(goal, cost, false);
        this._client_tracer = tracer;
    }

    public GoalFastMinimizeOld(Goal goal, IntExp cost, Object tracer, boolean goal_saves_solution) {
        this(goal, cost, false, goal_saves_solution);
        this._client_tracer = tracer;
    }

    @Override
    public Goal execute() throws Failure {
        this.constrainer().execute(new GoalAnd(this._goal_limit_cost, this._goal_find_solution, this._goal_save_cost, this._goal_decrement_cost, this._goal_fail));
        if (this._number_of_solutions > 0) {
            if (this._goal_saves_solution) {
                return null;
            }
            return new GoalAnd(new SetSavedCost(this.constrainer()), this._goal_find_solution);
        }
        this.constrainer().fail();
        return null;
    }

    @Override
    public String toString() {
        return "Use " + this._goal_find_solution.name() + " to minimize(" + this._cost.name() + ")";
    }

    class SetSavedCost
    extends GoalImpl {
        SetSavedCost(Constrainer C) {
            super(C, "SetSavedCost");
        }

        @Override
        public Goal execute() throws Failure {
            return GoalFastMinimizeOld.this._cost.equals(GoalFastMinimizeOld.this._saved_cost);
        }
    }

    class SaveCost
    extends GoalImpl {
        SaveCost(Constrainer C) {
            super(C, "SaveCost");
        }

        @Override
        public Goal execute() throws Failure {
            GoalFastMinimizeOld.this._saved_cost = GoalFastMinimizeOld.this._cost.value();
            GoalFastMinimizeOld.this._number_of_solutions++;
            if (GoalFastMinimizeOld.this._trace) {
                System.out.println("\nSolution " + GoalFastMinimizeOld.this._number_of_solutions + ": cost=" + GoalFastMinimizeOld.this._cost.value());
            }
            if (GoalFastMinimizeOld.this._client_tracer != null) {
                System.out.println(GoalFastMinimizeOld.this._client_tracer.toString());
            }
            return null;
        }
    }

    class DecrementCost
    extends GoalImpl {
        DecrementCost(Constrainer C) {
            super(C, "DecrementCost");
        }

        @Override
        public Goal execute() throws Failure {
            GoalFastMinimizeOld.this._goal_limit_cost.resetValue(GoalFastMinimizeOld.this._cost.value());
            return null;
        }
    }
}

