/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Vector;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.constrainer.impl.IntVarImpl;
import org.openl.ie.tools.FastVector;

public final class IntExpCardinality
extends IntVarImpl {
    private static final int[] event_map = new int[]{2, 5, 4, 5, 1, 7};
    private FastVector _vars;
    private int _card_value;
    private IntVar _possible_required;

    public IntExpCardinality(Constrainer constrainer, FastVector vars, int card_value) throws Failure {
        super(constrainer, 0, vars.size(), "C" + card_value, 0);
        this._card_value = card_value;
        int size = vars.size();
        this._vars = vars;
        int possible_instances = 0;
        int required_instances = 0;
        for (int i = 0; i < size; ++i) {
            IntExp exp = (IntExp)vars.elementAt(i);
            if (!exp.contains(card_value)) continue;
            ++possible_instances;
            if (!exp.bound()) continue;
            ++required_instances;
        }
        try {
            this.setMax(possible_instances);
            this.setMin(required_instances);
            int trace = 0;
            this._possible_required = this.constrainer().addIntVarTraceInternal(required_instances, possible_instances, "PR" + card_value, 0, trace);
            this._possible_required.attachObserver(new ObserverPossibleRequired());
        }
        catch (Failure f) {
            Constrainer.abort("invalid cardinality parameters");
        }
        this.attachObserver(new ObserverCardValue());
    }

    public IntExpCardinality(Constrainer constrainer, Vector vars, int card_value) throws Failure {
        this(constrainer, new FastVector(vars), card_value);
    }

    public void decMax() throws Failure {
        this._possible_required.setMax(this._possible_required.max() - 1);
    }

    public void incMin() throws Failure {
        this._possible_required.setMin(this._possible_required.min() + 1);
    }

    @Override
    public String toString() {
        return super.toString() + ":" + this._possible_required;
    }

    class ObserverPossibleRequired
    extends Observer {
        ObserverPossibleRequired() {
        }

        @Override
        public Object master() {
            return IntExpCardinality.this;
        }

        @Override
        public int subscriberMask() {
            return 6;
        }

        public String toString() {
            return "ObserverPossibleRequired";
        }

        @Override
        public void update(Subject var, EventOfInterest interest) throws Failure {
            IntEvent event = (IntEvent)interest;
            if (event.isMinEvent()) {
                IntExpCardinality.this.setMin(event.min());
            }
            if (event.isMaxEvent()) {
                IntExpCardinality.this.setMax(event.max());
            }
            if (IntExpCardinality.this._possible_required.min() == IntExpCardinality.this.max()) {
                for (int i = 0; i < IntExpCardinality.this._vars.size(); ++i) {
                    IntVar vari = (IntVar)IntExpCardinality.this._vars.elementAt(i);
                    if (vari.bound()) continue;
                    vari.removeValue(IntExpCardinality.this._card_value);
                }
            }
        }
    }

    class ObserverCardValue
    extends Observer {
        ObserverCardValue() {
        }

        @Override
        public Object master() {
            return IntExpCardinality.this;
        }

        @Override
        public int subscriberMask() {
            return 4;
        }

        public String toString() {
            return IntExpCardinality.this._name + "(ObserverCardValue)";
        }

        @Override
        public void update(Subject var, EventOfInterest interest) throws Failure {
            IntEvent e = (IntEvent)interest;
            int cardinality = e.max();
            if (IntExpCardinality.this._possible_required.min() == cardinality) {
                for (int i = 0; i < IntExpCardinality.this._vars.size(); ++i) {
                    IntVar vari = (IntVar)IntExpCardinality.this._vars.elementAt(i);
                    if (vari.bound()) continue;
                    vari.removeValue(IntExpCardinality.this._card_value);
                }
            }
        }
    }
}

