/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntCalc;
import org.openl.ie.constrainer.impl.IntExpImpl;

public class IntExpDivExp
extends IntExpImpl {
    private IntExp _numerator;
    private IntExp _denominator;
    private Observer _observer;
    private IntVar _quotient;

    public IntExpDivExp(IntExp numerator, IntExp denominator) {
        super(numerator.constrainer());
        this._numerator = numerator;
        this._denominator = denominator;
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + this._numerator.name() + "/" + this._denominator.name() + ")";
        }
        this._observer = new IntExpDivExpObserver();
        this._numerator.attachObserver(this._observer);
        this._denominator.attachObserver(this._observer);
        int trace = 0;
        this._quotient = this.constrainer().addIntVarTraceInternal(this.calc_min(), this.calc_max(), "div", 0, trace);
    }

    @Override
    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._quotient.attachObserver(observer);
    }

    private int calc_max() {
        int min1 = this._numerator.min();
        int max1 = this._numerator.max();
        int min2 = this._denominator.min();
        int max2 = this._denominator.max();
        if (max2 > 0 && min2 < 0) {
            return Math.max(Math.abs(min1), Math.abs(min2));
        }
        return Math.max(Math.max(min1 / min2, min1 / max2), Math.max(max1 / min2, max1 / max2));
    }

    private int calc_min() {
        int min1 = this._numerator.min();
        int max1 = this._numerator.max();
        int min2 = this._denominator.min();
        int max2 = this._denominator.max();
        if (max2 > 0 && min2 < 0) {
            return -Math.max(Math.abs(min1), Math.abs(min2));
        }
        return Math.min(Math.min(min1 / min2, min1 / max2), Math.min(max1 / min2, max1 / max2));
    }

    @Override
    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._quotient.detachObserver(observer);
    }

    @Override
    public int max() {
        return this._quotient.max();
    }

    @Override
    public int min() {
        return this._quotient.min();
    }

    @Override
    public void name(String name) {
        super.name(name);
        this._quotient.name(name);
    }

    @Override
    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._quotient.reattachObserver(observer);
    }

    @Override
    public void setMax(int max) throws Failure {
        if (max >= this.max()) {
            return;
        }
        this._quotient.setMax(max);
        int dmin = this._denominator.min();
        int dmax = this._denominator.max();
        int remainder = Math.max(Math.abs(dmin), Math.abs(dmax)) - 1;
        int nmin = IntCalc.productMin(max, this.min(), dmin, dmax);
        this._numerator.setMin(nmin - remainder);
        int nmax = IntCalc.productMax(max, this.min(), dmin, dmax);
        this._numerator.setMax(nmax + remainder);
    }

    @Override
    public void setMin(int min) throws Failure {
        if (min <= this.min()) {
            return;
        }
        this._quotient.setMin(min);
        int dmin = this._denominator.min();
        int dmax = this._denominator.max();
        int remainder = Math.max(Math.abs(dmin), Math.abs(dmax)) - 1;
        int nmin = IntCalc.productMin(min, this.max(), dmin, dmax);
        this._numerator.setMin(nmin - remainder);
        int nmax = IntCalc.productMax(min, this.max(), dmin, dmax);
        this._numerator.setMax(nmax + remainder);
    }

    @Override
    public void setValue(int val) throws Failure {
        this.setMin(val);
        this.setMax(val);
    }

    class IntExpDivExpObserver
    extends Observer {
        IntExpDivExpObserver() {
        }

        @Override
        public Object master() {
            return IntExpDivExp.this;
        }

        @Override
        public int subscriberMask() {
            return 7;
        }

        public String toString() {
            return "IntExpMulExpObserver: " + IntExpDivExp.this._numerator + " x " + IntExpDivExp.this._denominator;
        }

        @Override
        public void update(Subject subject, EventOfInterest event) throws Failure {
            if (IntExpDivExp.this._denominator.min() == 0 || IntExpDivExp.this._denominator.max() == 0) {
                IntExpDivExp.this._denominator.removeValue(0);
            }
            IntExpDivExp.this._quotient.setMin(IntExpDivExp.this.calc_min());
            IntExpDivExp.this._quotient.setMax(IntExpDivExp.this.calc_max());
        }
    }
}

