/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Expression;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.IntExpImpl;

public final class IntExpOr
extends IntExpImpl {
    private IntExp _exp1;
    private IntExp _exp2;
    private ExpressionObserver _observer1;
    private ExpressionObserver _observer2;

    public IntExpOr(IntExp exp1, IntExp exp2) {
        super(exp1.constrainer(), "");
        this._exp1 = exp1;
        this._exp2 = exp2;
        this._observer1 = new ExpOrExpObserver(this._exp1);
        this._exp1.attachObserver(this._observer1);
        this._observer2 = new ExpOrExpObserver(this._exp2);
        this._exp2.attachObserver(this._observer2);
    }

    @Override
    public boolean contains(int value) {
        return this._exp1.contains(value) || this._exp2.contains(value);
    }

    @Override
    public int max() {
        return Math.max(this._exp1.max(), this._exp2.max());
    }

    @Override
    public int min() {
        return Math.min(this._exp1.min(), this._exp2.min());
    }

    @Override
    public void onMaskChange() {
        this._observer1.publish(this.publisherMask(), this._exp1);
        this._observer2.publish(this.publisherMask(), this._exp2);
    }

    @Override
    public void removeValue(int value) throws Failure {
        this._exp1.removeValue(value);
        this._exp2.removeValue(value);
    }

    @Override
    public void setMax(int max) throws Failure {
        this._exp1.setMax(max);
        this._exp2.setMax(max);
    }

    @Override
    public void setMin(int min) throws Failure {
        this._exp1.setMin(min);
        this._exp2.setMin(min);
    }

    @Override
    public void setValue(int value) throws Failure {
        this._exp1.setValue(value);
        this._exp2.setValue(value);
    }

    @Override
    public int value() throws Failure {
        return (this._exp1.value() + this._exp2.value()) / 2;
    }

    class ExpOrExpObserver
    extends ExpressionObserver {
        private IntExp _second;

        ExpOrExpObserver(Expression exp) {
            this._second = exp == IntExpOr.this._exp1 ? IntExpOr.this._exp2 : IntExpOr.this._exp1;
        }

        @Override
        public Object master() {
            return IntExpOr.this;
        }

        @Override
        public String toString() {
            return "ExpOrObserver: ";
        }
    }
}

