/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntExpImpl;

public final class IntExpPowIntExp
extends IntExpImpl {
    private IntExp _base;
    private IntExp _power;
    private IntVar _result;
    private IntExpPowExpCalc _calc;
    private ExpPowerExpBaseObserver _base_observer;
    private ExpPowerExpPowerObserver _power_observer;

    public IntExpPowIntExp(IntExp exp, IntExp pow_exp) {
        super(exp.constrainer());
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + exp.name() + "**" + pow_exp.name() + ")";
        }
        this._base = exp;
        this._power = pow_exp;
        this._base_observer = new ExpPowerExpBaseObserver();
        this._base.attachObserver(this._base_observer);
        this._power_observer = new ExpPowerExpPowerObserver();
        this._power.attachObserver(this._power_observer);
        this.createCalc();
        this._calc.createResult();
    }

    @Override
    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._result.attachObserver(observer);
    }

    private void createCalc() {
        this._calc = this._base.min() >= 0 ? new CalcP(this._base, this._power) : (this._base.max() <= 0 ? new CalcN(this._base, this._power) : new CalcG(this._base, this._power));
    }

    private void createResultVar(int min, int max) {
        int trace = 0;
        this._result = this.constrainer().addIntVarTraceInternal(min, max, this._name, 0, trace);
    }

    @Override
    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._result.detachObserver(observer);
    }

    @Override
    public int max() {
        return this._result.max();
    }

    private int max_even_power() {
        int max_even_power;
        if (this._power.max() % 2 == 0) {
            return this._power.max();
        }
        int min_power = this._power.min();
        for (max_even_power = this._power.max() - 1; !this._power.contains(max_even_power) && max_even_power > min_power; max_even_power -= 2) {
        }
        if (max_even_power < min_power) {
            return -1;
        }
        return max_even_power;
    }

    private int max_odd_power() {
        int max_even_power;
        if (this._power.max() % 2 == 1) {
            return this._power.max();
        }
        int min_power = this._power.min();
        for (max_even_power = this._power.max() - 1; !this._power.contains(max_even_power) && max_even_power > min_power; max_even_power -= 2) {
        }
        if (max_even_power < min_power) {
            return -1;
        }
        return max_even_power;
    }

    @Override
    public int min() {
        return this._result.min();
    }

    @Override
    public void name(String name) {
        super.name(name);
        this._result.name(name);
    }

    @Override
    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._result.reattachObserver(observer);
    }

    private void remove_all_even_power() throws Failure {
        int min_power = this._power.min();
        int max_power = this._power.max();
        for (int power = min_power; power <= max_power; ++power) {
            if (power % 2 != 0) continue;
            this._power.removeValue(power);
        }
    }

    private void remove_all_odd_power() throws Failure {
        int min_power = this._power.min();
        int max_power = this._power.max();
        for (int power = min_power; power <= max_power; ++power) {
            if (power % 2 != 1) continue;
            this._power.removeValue(power);
        }
    }

    @Override
    public void setMax(int max) throws Failure {
        if (max >= this.max()) {
            return;
        }
        this._result.setMax(max);
        this._calc.setMax(max);
    }

    @Override
    public void setMin(int min) throws Failure {
        if (min <= this.min()) {
            return;
        }
        this._result.setMin(min);
        this._calc.setMin(min);
    }

    @Override
    public void setValue(int value) throws Failure {
        this.setMin(value);
        this.setMax(value);
    }

    private void updateResultVar(int min, int max) throws Failure {
        this._result.setMin(min);
        this._result.setMax(max);
    }

    abstract class IntExpPowExpCalc {
        IntExpPowExpCalc() {
        }

        public void createResult() {
            IntExpPowIntExp.this.createResultVar(this.min(), this.max());
        }

        public abstract int max();

        public abstract int min();

        public abstract void setMax(int var1) throws Failure;

        public abstract void setMin(int var1) throws Failure;

        public void updateFromObserver() throws Failure {
            IntExpPowIntExp.this.updateResultVar(this.min(), this.max());
        }
    }

    class ExpPowerExpPowerObserver
    extends Observer {
        ExpPowerExpPowerObserver() {
        }

        @Override
        public Object master() {
            return IntExpPowIntExp.this;
        }

        @Override
        public int subscriberMask() {
            return 15;
        }

        public String toString() {
            return "ExpPowerExpPowerObserver: " + IntExpPowIntExp.this._base + " ** " + IntExpPowIntExp.this._power;
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntExpPowIntExp.this._calc.updateFromObserver();
        }
    }

    class ExpPowerExpBaseObserver
    extends Observer {
        ExpPowerExpBaseObserver() {
        }

        @Override
        public Object master() {
            return IntExpPowIntExp.this;
        }

        @Override
        public int subscriberMask() {
            return 7;
        }

        public String toString() {
            return "ExpPowerExpBaseObserver: " + IntExpPowIntExp.this._base + " ** " + IntExpPowIntExp.this._power;
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntExpPowIntExp.this._calc.updateFromObserver();
        }
    }

    final class CalcP
    extends IntExpPowExpCalc {
        private IntExp _base;
        private IntExp _power;

        public CalcP(IntExp base, IntExp power) {
            this._base = base;
            this._power = power;
        }

        @Override
        public int max() {
            return (int)Math.pow(this._base.max(), this._power.max());
        }

        @Override
        public int min() {
            if (this._base.min() == 0) {
                if (this._power.max() == 0) {
                    return 1;
                }
                return 0;
            }
            return (int)Math.pow(this._base.min(), this._power.min());
        }

        @Override
        public void setMax(int max) throws Failure {
            int power_min;
            int base_min = this._base.min();
            if (base_min > 1 && (int)Math.pow(base_min, this._power.max()) > max) {
                this._power.setMax((int)(Math.log(max) / Math.log(base_min)));
            }
            if ((power_min = this._power.min()) > 0 && (int)Math.pow(this._base.max(), power_min) > max) {
                this._base.setMin((int)Math.pow(max, 1.0 / (double)power_min));
            }
        }

        @Override
        public void setMin(int min) throws Failure {
            int power_max;
            int base_max = this._base.max();
            if (base_max > 1 && (int)Math.pow(base_max, this._power.min()) < min) {
                int min_power = (int)(Math.log(min) / Math.log(base_max));
                if ((int)Math.pow(base_max, min_power) < min) {
                    ++min_power;
                }
                this._power.setMin(min_power);
            }
            if ((power_max = this._power.max()) > 0 && (int)Math.pow(this._base.min(), power_max) < min) {
                int min_base = (int)Math.pow(min, 1.0 / (double)power_max);
                if ((int)Math.pow(min_base, power_max) < min) {
                    ++min_base;
                }
                this._base.setMin(min_base);
            }
        }
    }

    final class CalcN
    extends IntExpPowExpCalc {
        private IntExp _base;
        private IntExp _power;

        public CalcN(IntExp base, IntExp power) {
            this._base = base;
            this._power = power;
        }

        @Override
        public int max() {
            int max_even_power = IntExpPowIntExp.this.max_even_power();
            if (max_even_power > 0) {
                return (int)Math.pow(this._base.min(), max_even_power);
            }
            if (this._base.max() == 0) {
                if (this._power.max() == 0) {
                    return 1;
                }
                return 0;
            }
            return (int)Math.pow(this._base.max(), this._power.min());
        }

        @Override
        public int min() {
            int max_odd_power = IntExpPowIntExp.this.max_odd_power();
            if (max_odd_power > 0) {
                return (int)Math.pow(this._base.min(), max_odd_power);
            }
            if (this._base.max() == 0) {
                if (this._power.max() == 0) {
                    return 1;
                }
                return 0;
            }
            return (int)Math.pow(this._base.max(), this._power.min());
        }

        @Override
        public void setMax(int max) throws Failure {
            if (max <= 0) {
                int power_min;
                IntExpPowIntExp.this.remove_all_even_power();
                int base_max = -this._base.max();
                if (base_max > 1 && (int)Math.pow(base_max, this._power.max()) > -max) {
                    this._power.setMax((int)(Math.log(-max) / Math.log(base_max)));
                }
                if ((power_min = this._power.min()) > 0 && (int)Math.pow(-this._base.min(), power_min) > -max) {
                    this._base.setMin(-((int)Math.pow(-max, 1.0 / (double)power_min)));
                }
            } else {
                int power_min;
                int abs_max = Math.max(max, Math.abs(IntExpPowIntExp.this._result.min()));
                int base_max = -this._base.max();
                if (base_max > 1 && (int)Math.pow(base_max, this._power.max()) > abs_max) {
                    this._power.setMax((int)(Math.log(abs_max) / Math.log(base_max)));
                }
                if ((power_min = this._power.min()) > 0 && (int)Math.pow(-this._base.min(), power_min) > abs_max) {
                    this._base.setMin(-((int)Math.pow(abs_max, 1.0 / (double)power_min)));
                }
            }
        }

        @Override
        public void setMin(int min) throws Failure {
            if (min > 0) {
                int power_max;
                IntExpPowIntExp.this.remove_all_odd_power();
                int base_max = -this._base.max();
                if (base_max > 1 && (int)Math.pow(base_max, this._power.min()) < min) {
                    int min_power = (int)(Math.log(min) / Math.log(base_max));
                    if ((int)Math.pow(base_max, min_power) < min) {
                        ++min_power;
                    }
                    this._power.setMax(min_power);
                }
                if ((power_max = this._power.max()) > 0 && (int)Math.pow(this._base.min(), power_max) < min) {
                    int min_base = (int)Math.pow(min, 1.0 / (double)power_max);
                    if ((int)Math.pow(min_base, power_max) < min) {
                        ++min_base;
                    }
                    this._base.setMax(-min_base);
                }
            } else {
                int power_max;
                int base_max = -this._base.max();
                if (base_max > 1 && (int)Math.pow(base_max, this._power.min()) < min) {
                    int min_power = (int)(Math.log(min) / Math.log(base_max));
                    if ((int)Math.pow(base_max, min_power) < min) {
                        ++min_power;
                    }
                    this._power.setMin(min_power);
                }
                if ((power_max = this._power.max()) > 0 && (int)Math.pow(this._base.min(), power_max) < min) {
                    int max_base = (int)Math.pow(min, 1.0 / (double)power_max);
                    if ((int)Math.pow(max_base, power_max) < min) {
                        ++max_base;
                    }
                    this._base.setMax(-max_base);
                }
            }
        }
    }

    final class CalcG
    extends IntExpPowExpCalc {
        private IntExp _base;
        private IntExp _power;

        public CalcG(IntExp base, IntExp power) {
            this._base = base;
            this._power = power;
        }

        @Override
        public int max() {
            if (this._base.min() >= 0) {
                return (int)Math.pow(this._base.max(), this._power.max());
            }
            if (this._power.max() % 2 == 0) {
                return (int)Math.pow(Math.max(this._base.max(), -this._base.min()), this._power.max());
            }
            int max_even_power = IntExpPowIntExp.this.max_even_power();
            if (max_even_power < 0) {
                if (this._base.max() == 0) {
                    return 0;
                }
                return (int)Math.pow(this._base.max(), this._power.max());
            }
            return (int)Math.max(Math.pow(this._base.max(), this._power.max()), Math.pow(this._base.min(), max_even_power));
        }

        @Override
        public int min() {
            if (this._base.min() == 0) {
                if (this._power.max() == 0) {
                    return 1;
                }
                return 0;
            }
            if (this._base.min() > 0) {
                return (int)Math.pow(this._base.min(), this._power.min());
            }
            if (this._power.max() % 2 == 0) {
                int max_odd_power = IntExpPowIntExp.this.max_odd_power();
                if (max_odd_power < 0) {
                    if (this._base.contains(0)) {
                        if (this._power.max() == 0) {
                            return 1;
                        }
                        return 0;
                    }
                    if (this._base.max() > 0) {
                        int max_negative;
                        int min_positive;
                        for (min_positive = 1; !this._base.contains(min_positive) && min_positive <= this._base.max(); ++min_positive) {
                        }
                        for (max_negative = -1; !this._base.contains(max_negative) && max_negative >= this._base.min(); --max_negative) {
                        }
                        return (int)Math.pow(Math.min(min_positive, -max_negative), this._power.min());
                    }
                    return (int)Math.pow(this._base.max(), this._power.min());
                }
                return (int)Math.pow(this._base.min(), max_odd_power);
            }
            return (int)Math.pow(this._base.min(), this._power.max());
        }

        @Override
        public void setMax(int max) throws Failure {
            if (max <= 0) {
                IntExpPowIntExp.this.remove_all_odd_power();
            }
        }

        @Override
        public void setMin(int min) throws Failure {
            if (min > 0) {
                IntExpPowIntExp.this.remove_all_even_power();
            }
        }
    }
}

