/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.exigensimplex.glpkimpl;

import org.openl.ie.exigensimplex.LPProblem;
import org.openl.ie.exigensimplex.MatrixRow;
import org.openl.ie.exigensimplex.NoSolutionException;
import org.openl.ie.exigensimplex.VarBounds;
import org.openl.ie.exigensimplex.glpkimpl.Algorithm;
import org.openl.ie.exigensimplex.glpkimpl.MIPAlgorithm;
import org.openl.ie.simplex.Direction;
import org.openl.ie.simplex.IPSErrorCodes;
import org.openl.ie.simplex.LPErrorCodes;
import org.openl.ie.simplex.LPX;
import org.openl.ie.simplex.MIPErrorCodes;
import org.openl.ie.simplex.NotAMIPProblem;
import org.openl.ie.simplex.SolutionErrorCodes;
import org.openl.ie.simplex.Status;
import org.openl.ie.simplex.VarType;
import org.openl.ie.simplex.WrongLPX;

public class GLPKLPProblem
implements LPProblem {
    private int _lpAlgorithm = 0;
    private int _mipAlgorithm = 0;
    private int _successfullyUsedLPAlgorithm = -1;
    private int _successfullyUsedMIPAlgorithm = -1;
    private int _lastErrorWhileSolvingLP = 0;
    private int _lastErrorWhileSolvingMIP = 0;
    private LPX _lp = new LPX();

    public static String errorToString(int errorCode) {
        return Status.translate(errorCode);
    }

    public GLPKLPProblem() {
        this._lp.createLPX();
    }

    @Override
    public void addColumns(int num) {
        try {
            this._lp.addColumns(num);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void addColumns(int num, String[] names) {
        if (names.length != num) {
            throw new IllegalArgumentException("addRows(int, String[]) : wrong size of String[] array");
        }
        try {
            int oldnum = this._lp.getNumCols();
            this._lp.addColumns(num);
            for (int i = 0; i < names.length; ++i) {
                this._lp.setColName(i + oldnum - 1, names[i]);
            }
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void addColumns(int num, String[] names, int[] types, double[] ubounds, double[] lbounds) {
        try {
            if (num != names.length || num != ubounds.length || num != lbounds.length || num != ubounds.length) {
                throw new IllegalArgumentException("addRows(int, String[], double[], double[])");
            }
            int oldnum = this._lp.getNumCols();
            this._lp.addColumns(num);
            for (int i = 0; i < names.length; ++i) {
                this._lp.setColName(i + oldnum - 1, names[i]);
                VarType type = new VarType(this.parseBoundsType(types[i]), lbounds[i], ubounds[i]);
                this._lp.setColBnds(i + oldnum - 1, type.getType(), type.getLb(), type.getUb());
            }
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void addRows(int num) {
        try {
            this._lp.addRows(num);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void addRows(int num, String[] names) {
        try {
            if (names.length != num) {
                throw new IllegalArgumentException("addRows(int, String[]) : wrong size of String[] array");
            }
            int oldnum = this._lp.getNumRows();
            this._lp.addRows(num);
            for (int i = 0; i < names.length; ++i) {
                this._lp.setRowName(i + oldnum - 1, names[i]);
            }
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void addRows(int num, String[] names, int[] types, double[] lbounds, double[] ubounds) {
        try {
            if (num != names.length || num != ubounds.length || num != lbounds.length || num != ubounds.length) {
                throw new IllegalArgumentException("addRows(int, String[], double[], double[])");
            }
            int oldnum = this._lp.getNumRows();
            this._lp.addRows(num);
            for (int i = 0; i < names.length; ++i) {
                this._lp.setRowName(i + oldnum - 1, names[i]);
                VarType type = new VarType(this.parseBoundsType(types[i]), lbounds[i], ubounds[i]);
                this._lp.setRowBnds(i + oldnum - 1, type.getType(), type.getLb(), type.getUb());
            }
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void ascribeMIPStatus() {
        try {
            this._lp.setMIPStatus();
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    private boolean checkSymbolicNames(String name) {
        return true;
    }

    @Override
    public void deleteCurrentLP() {
        this._lp.deleteLPX();
        this._lp.createLPX();
    }

    private void ensureFeasibleSolutionExists() throws NoSolutionException {
        int status = this._lp.getStatus();
        if (!LPErrorCodes.isFeasible(status)) {
            throw new NoSolutionException(status);
        }
    }

    private void ensureMIPFeasibleSolutionExists() throws NoSolutionException {
        int status = this._lp.getMIPStatus();
        if (!MIPErrorCodes.isFeasible(status)) {
            throw new NoSolutionException(status);
        }
    }

    @Override
    public String errorAsString(int errorCode) {
        return Status.translate(errorCode);
    }

    protected void finalize() {
        this._lp.deleteLPX();
    }

    @Override
    public int getAlgorithm() {
        return this._lpAlgorithm;
    }

    @Override
    public boolean getBoolParam(int paramNum) {
        try {
            return this._lp.getBoolParm(paramNum) != 0.0;
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public VarBounds getColumnBounds(int num) {
        try {
            VarType type = this._lp.getColBnds(num);
            return new VarBounds(this.inverseParseBoundsType(type.getType()), type.getLb(), type.getUb());
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public double getColumnCoeff(int num) {
        try {
            return this._lp.getColCoef(num);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public String getColumnName(int num) {
        try {
            return this._lp.getColName(num);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error has occured");
        }
    }

    @Override
    public double getColumnValue(int colnum) throws NoSolutionException {
        try {
            this.ensureFeasibleSolutionExists();
            return this._lp.getBasicInfo(colnum).getPrim();
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public int getIntParam(int paramNum) {
        try {
            return this._lp.getIntParm(paramNum);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public int getLastLPError() {
        return this._lastErrorWhileSolvingLP;
    }

    @Override
    public int getlastMIPError() {
        return this._lastErrorWhileSolvingMIP;
    }

    @Override
    public double getMatrixCoeff(int i, int j) {
        throw new RuntimeException("getMatrixCoeff is not implemented");
    }

    @Override
    public MatrixRow getMatrixColumn(int num) {
        try {
            return new MatrixRow(this._lp.getMatCols(num));
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public MatrixRow getMatrixRow(int num) {
        try {
            return new MatrixRow(this._lp.getMatRow(num));
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public int getMIPAlgorithm() {
        return this._mipAlgorithm;
    }

    @Override
    public double getMIPColumnValue(int colnum) throws NoSolutionException {
        try {
            int status = this._lp.getMIPStatus();
            if (!MIPErrorCodes.isFeasible(status)) {
                throw new NoSolutionException(status);
            }
            return this._lp.getMIPBasic(colnum);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
        catch (NotAMIPProblem ex) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public double getMIPObjVal() throws NoSolutionException {
        try {
            return this._lp.getMIPObjVal();
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
        catch (org.openl.ie.simplex.NoSolutionException ex) {
            throw new NoSolutionException(this._lp.getMIPStatus());
        }
    }

    @Override
    public double getMIPRowValue(int rownum) throws NoSolutionException {
        try {
            int status = this._lp.getMIPStatus();
            if (!MIPErrorCodes.isFeasible(status)) {
                throw new NoSolutionException(status);
            }
            return this._lp.getMIPAux(rownum);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
        catch (NotAMIPProblem ex) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public int getMIPStatus() {
        return this._lp.getMIPStatus();
    }

    @Override
    public int getNumBooleanColumns() {
        return this._lp.getNumBoolVars();
    }

    @Override
    public int getNumColumns() {
        return this._lp.getNumCols();
    }

    @Override
    public int getNumIntegerColumns() {
        return this._lp.getNumIntVars();
    }

    @Override
    public int getNumNonZero() {
        return this._lp.getNumNz();
    }

    @Override
    public int getNumRows() {
        return this._lp.getNumRows();
    }

    @Override
    public double getObjConst() {
        try {
            return this._lp.getObjConst();
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public double getObjValue() throws NoSolutionException {
        try {
            return this._lp.getObjVal();
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
        catch (org.openl.ie.simplex.NoSolutionException ex) {
            int status = this._lp.getStatus();
            throw new NoSolutionException(status, Status.translate(status));
        }
    }

    @Override
    public String getProblemName() {
        return this._lp.getName();
    }

    @Override
    public int getProblemStatus() {
        if (this._lp.getIPSStatus() == IPSErrorCodes.LPX_T_UNDEF) {
            return this._lp.getStatus();
        }
        return this._lp.getIPSStatus();
    }

    @Override
    public double getRealParam(int paramNum) {
        try {
            return this._lp.getRealParm(paramNum);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public VarBounds getRowBounds(int num) {
        try {
            VarType type = this._lp.getRowBnds(num);
            return new VarBounds(this.inverseParseBoundsType(type.getType()), type.getLb(), type.getUb());
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public double getRowCoeff(int num) {
        try {
            return this._lp.getRowCoef(num);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public String getRowName(int num) {
        try {
            return this._lp.getRowName(num);
        }
        catch (WrongLPX ex) {
            throw new RuntimeException("internal error has occured");
        }
    }

    @Override
    public double getRowValue(int rownum) throws NoSolutionException {
        try {
            this.ensureFeasibleSolutionExists();
            return this._lp.getAuxInfo(rownum).getPrim();
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public String getStringParam(int paramNum) {
        return "";
    }

    private boolean hasFeasibleMIPSolution() {
        return MIPErrorCodes.isFeasible(this._lp.getMIPStatus());
    }

    private boolean hasFeasibleSolution() {
        return LPErrorCodes.isFeasible(this._lp.getStatus());
    }

    private int inverseParseBoundsType(int type) {
        if (type == VarType.LPX_UP) {
            return 0;
        }
        if (type == VarType.LPX_LO) {
            return 1;
        }
        if (type == VarType.LPX_DB) {
            return 2;
        }
        if (type == VarType.LPX_FX) {
            return 4;
        }
        if (type == VarType.LPX_FR) {
            return 3;
        }
        return 2;
    }

    @Override
    public boolean isColumnBoolean(int colnum) {
        try {
            VarType vt = this._lp.getColBnds(colnum);
            return vt.getLb() == 0.0 && vt.getUb() == 1.0 && this._lp.isIntVar(colnum);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public boolean isColumnInteger(int colnum) {
        try {
            return this._lp.isIntVar(colnum);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public boolean isFeasibleLPSolutionFound() {
        return LPErrorCodes.isFeasible(this._lp.getStatus()) || IPSErrorCodes.isOptimal(this._lp.getIPSStatus());
    }

    @Override
    public boolean isFeasibleMIPSolutionFound() {
        return MIPErrorCodes.isFeasible(this._lp.getMIPStatus());
    }

    @Override
    public boolean isMIP() {
        return this._lp.isMIP();
    }

    @Override
    public boolean isOptimalLPSolutionFound() {
        return LPErrorCodes.isOptimal(this._lp.getStatus()) || IPSErrorCodes.isOptimal(this._lp.getIPSStatus());
    }

    @Override
    public boolean isOptimalMIPSolutionFound() {
        return MIPErrorCodes.isOptimal(this._lp.getMIPStatus());
    }

    public boolean isRowBoolean(int rownum) {
        return false;
    }

    public boolean isRowInteger(int rownum) {
        return false;
    }

    @Override
    public void markColumnAsBoolVar(int colnum) {
        try {
            if (!this._lp.isMIP()) {
                this.ascribeMIPStatus();
            }
            this._lp.makeVarInt(colnum);
            this._lp.setColBnds(colnum, this.parseBoundsType(2), 0.0, 1.0);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
        catch (NotAMIPProblem ex) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void markColumnAsFloatVar(int colnum) {
        try {
            this._lp.makeVarReal(colnum);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void markColumnAsIntVar(int colnum) {
        try {
            if (!this._lp.isMIP()) {
                this.ascribeMIPStatus();
            }
            this._lp.makeVarInt(colnum);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
        catch (NotAMIPProblem ex) {
            throw new RuntimeException("Internal error");
        }
    }

    private int parseBoundsType(int type) {
        switch (type) {
            case 0: {
                return VarType.LPX_UP;
            }
            case 1: {
                return VarType.LPX_LO;
            }
            case 2: {
                return VarType.LPX_DB;
            }
            case 4: {
                return VarType.LPX_FX;
            }
            case 3: {
                return VarType.LPX_FR;
            }
        }
        return VarType.LPX_DB;
    }

    @Override
    public void printMIPSolutionToFile(String filename) {
        this._lp.printMIPSolution(filename);
    }

    @Override
    public void printSolutionToFile(String filename) {
        if (this._successfullyUsedLPAlgorithm == 1) {
            this._lp.printIPSolution(filename);
            return;
        }
        if (this._successfullyUsedLPAlgorithm == 0) {
            this._lp.printSolution(filename);
            return;
        }
        if (this._successfullyUsedLPAlgorithm == -1) {
            this._lp.printSolution(filename);
            return;
        }
    }

    public void readFromFile(String filename) {
    }

    @Override
    public void readLP(String filename) {
        this._lp.readLP(filename);
    }

    @Override
    public void readMPS(String filename) {
        this._lp.readMPS(filename);
    }

    @Override
    public void saveLPToMPS(String filename) {
        this._lp.saveLPtoMPSFormat(filename);
    }

    @Override
    public void setAlgorithm(int algorithm) {
        if (!Algorithm.isAvailableAlgorithm(algorithm)) {
            throw new IllegalArgumentException("Unsupported algorithm: " + algorithm);
        }
        this._lpAlgorithm = algorithm;
    }

    @Override
    public void setBoolParam(int paramNum, boolean value) {
        this._lp.setBoolParm(paramNum, value);
    }

    @Override
    public void setColumnBounds(int num, int type, double lbound, double ubound) {
        try {
            this._lp.setColBnds(num, this.parseBoundsType(type), lbound, ubound);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void setColumnCoeff(int num, double value) {
        try {
            this._lp.setColCoef(num, value);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void setColumnName(int num, String name) {
        if (!this.checkSymbolicNames(name)) {
            throw new IllegalArgumentException("GLPKLP.setRowName: incorrect symbolic name");
        }
        this._lp.setColName(num, name);
    }

    @Override
    public void setIntParam(int paramNum, int value) {
        this._lp.setIntParm(paramNum, value);
    }

    @Override
    public void setMatrixCoeff(int i, int j, double val) {
        throw new RuntimeException("setMatrixCoeff is not implemented");
    }

    @Override
    public void setMatrixColumn(int num, int[] locations, double[] values) {
        try {
            this._lp.setMatCol(num, locations, values);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void setMatrixColumn(int num, MatrixRow matcol) {
        try {
            this._lp.setMatCol(num, matcol.getLocations(), matcol.getValues());
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void setMatrixRow(int num, int[] locations, double[] values) {
        try {
            this._lp.setMatRow(num, locations, values);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void setMatrixRow(int num, MatrixRow matrow) {
        try {
            this._lp.setMatRow(num, matrow.getLocations(), matrow.getValues());
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void setMIPAlgorithm(int algorithm) {
        if (!MIPAlgorithm.isAvailableAlgorithm(algorithm)) {
            throw new IllegalArgumentException("Unsupported algorithm: " + algorithm);
        }
        this._mipAlgorithm = algorithm;
    }

    @Override
    public void setObjConst(double value) {
        try {
            this._lp.setObjConst(value);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    private void setOptimizationDirection(int direction) {
        try {
            if (direction == 1) {
                if (this._lp.getObjDir() != Direction.MAX) {
                    this._lp.setObjDir(Direction.MAX);
                }
            } else if (this._lp.getObjDir() != Direction.MIN) {
                this._lp.setObjDir(Direction.MIN);
            }
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void setProblemName(String name) {
        if (!this.checkSymbolicNames(name)) {
            throw new IllegalArgumentException("GLPKLP.setRowName: incorrect symbolic name");
        }
        try {
            this._lp.setName(name);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void setRealParam(int paramNum, double value) {
        this._lp.setRealParm(paramNum, value);
    }

    @Override
    public void setRowBounds(int num, int type, double lbound, double ubound) {
        try {
            this._lp.setRowBnds(num, this.parseBoundsType(type), lbound, ubound);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void setRowCoeff(int num, double val) {
        try {
            this._lp.setRowCoef(num, val);
        }
        catch (WrongLPX wrglpx) {
            throw new RuntimeException("Internal error");
        }
    }

    @Override
    public void setRowName(int num, String name) {
        if (!this.checkSymbolicNames(name)) {
            throw new IllegalArgumentException("GLPKLP.setRowName: incorrect symbolic name");
        }
        this._lp.setRowName(num, name);
    }

    @Override
    public void setStringParam(int paramNum, String value) {
    }

    @Override
    public int solveLP() {
        int success;
        int solution;
        switch (this._lpAlgorithm) {
            case 0: {
                solution = this._lp.simplexSolve();
                int status = this._lp.getStatus();
                success = LPErrorCodes.isFeasible(status) ? 0 : status;
                break;
            }
            case 1: {
                solution = this._lp.interiorPointSolve();
                int status = this._lp.getIPSStatus();
                success = IPSErrorCodes.isOptimal(status) ? 0 : status;
                break;
            }
            default: {
                solution = 0;
                boolean status = false;
                success = 0;
            }
        }
        this._lastErrorWhileSolvingLP = !SolutionErrorCodes.isSuccessful(solution) ? solution : 0;
        this._successfullyUsedLPAlgorithm = success == 0 ? this._lpAlgorithm : -1;
        return success;
    }

    @Override
    public int solveLP(int direction) {
        this.setOptimizationDirection(direction);
        return this.solveLP();
    }

    @Override
    public int solveMIP() {
        int success;
        int solution;
        if (!this.isMIP()) {
            return 3000;
        }
        switch (this._mipAlgorithm) {
            case 0: {
                solution = this._lp.solveMIP();
                int status = this._lp.getMIPStatus();
                success = MIPErrorCodes.isFeasible(status) ? 0 : 1;
                break;
            }
            default: {
                boolean status = false;
                solution = 0;
                success = 0;
            }
        }
        if (success == 0) {
            this._successfullyUsedMIPAlgorithm = this._mipAlgorithm;
        } else {
            this._successfullyUsedLPAlgorithm = -1;
        }
        this._lastErrorWhileSolvingMIP = !SolutionErrorCodes.isSuccessful(solution) ? solution : 0;
        return success;
    }

    @Override
    public int solveMIP(int direction) {
        this.setOptimizationDirection(direction);
        return this.solveMIP();
    }
}

