/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.scheduler;

import java.util.Arrays;
import org.openl.ie.constrainer.ConstraintImpl;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.scheduler.AlternativeResourceSet;
import org.openl.ie.scheduler.GoalAssignAlternative;
import org.openl.ie.scheduler.Job;
import org.openl.ie.scheduler.Resource;
import org.openl.ie.scheduler.Schedule;

public class AlternativeResourceConstraint
extends ConstraintImpl {
    private Schedule _schedule;
    private Resource[] _rset;
    private Resource _assigned;
    private Job _job;
    private int _capacity;
    private IntVar _capacityVar;
    private boolean[] _possibleAssignment;
    private Observer _observer;
    private Goal _goal = null;
    private IntExp _flag = null;

    public AlternativeResourceConstraint(Job j, AlternativeResourceSet res, int capacity) {
        this(j, res.toArray(), capacity, null);
    }

    public AlternativeResourceConstraint(Job j, AlternativeResourceSet res, IntVar capacity) {
        this(j, res.toArray(), -1, capacity);
    }

    public AlternativeResourceConstraint(Job j, Resource[] res, int capacity, IntVar capacityVar) {
        super(j.constrainer(), "AlternativeResourceConstraint");
        this._job = j;
        this._schedule = this._job.schedule();
        this._rset = res;
        this._assigned = null;
        this._capacity = capacity;
        this._capacityVar = capacityVar;
        this._possibleAssignment = new boolean[this._rset.length];
        Arrays.fill(this._possibleAssignment, true);
        this._schedule.addRequirement(this);
    }

    public void assignResource(Resource res) {
        this._assigned = res;
    }

    @Override
    public Goal execute() throws Failure {
        this._goal = new GoalAssignAlternative(this, this._possibleAssignment);
        this._observer = new AltResConstrObserver();
        this._job.getStartVariable().attachObserver(this._observer);
        return null;
    }

    public void flush() {
        this._assigned = null;
    }

    public int getCapacity() {
        return this._capacity;
    }

    public IntVar getCapacityVar() {
        return this._capacityVar;
    }

    public Job getJob() {
        return this._job;
    }

    public Resource getResource() {
        return this._assigned;
    }

    public Resource getResource(int n) {
        return this._rset[n];
    }

    public Resource[] resources() {
        return this._rset;
    }

    public void setNotPossible(Resource r) {
        for (int i = 0; i < this._rset.length; ++i) {
            if (this._rset[i] != r) continue;
            this._possibleAssignment[i] = false;
            return;
        }
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this._job + " requires [ ");
        for (int i = 0; i < this._rset.length; ++i) {
            if (!this._possibleAssignment[i]) continue;
            out.append(this._rset[i] + " ");
        }
        out.append("]");
        return out.toString();
    }

    class AltResConstrObserver
    extends Observer {
        AltResConstrObserver() {
        }

        @Override
        public Object master() {
            return this;
        }

        @Override
        public int subscriberMask() {
            return 1;
        }

        public String toString() {
            return "AlternativeResourceConstraintObserver";
        }

        @Override
        public void update(Subject var, EventOfInterest interest) throws Failure {
            IntExp event_var = (IntExp)var;
            AlternativeResourceConstraint.this._goal.execute();
        }
    }
}

