/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.scheduler;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.scheduler.AlternativeResourceConstraint;
import org.openl.ie.scheduler.Job;
import org.openl.ie.scheduler.JobInterval;
import org.openl.ie.scheduler.Resource;
import org.openl.ie.scheduler.ResourceDiscrete;
import org.openl.ie.scheduler.ResourceUnary;
import org.openl.ie.tools.FastVector;

public class Schedule {
    private String _name;
    private FastVector _jobs;
    private FastVector _resources;
    private FastVector _requirements;
    private int _scheduleStart;
    private int _scheduleEnd;
    private Constrainer _constrainer;

    public Schedule(Constrainer c, int start, int end) {
        this._constrainer = c;
        this._scheduleStart = start;
        this._scheduleEnd = end;
        this._jobs = new FastVector();
        this._resources = new FastVector();
        this._requirements = new FastVector();
    }

    public Job addJob(int duration, String name) throws Failure {
        JobInterval job = new JobInterval(this, duration);
        job.setName(name);
        this._jobs.addElement(job);
        return job;
    }

    public Job addJob(Job job) throws Failure {
        this._jobs.addElement(job);
        return job;
    }

    public void addRequirement(AlternativeResourceConstraint c) {
        this._requirements.addElement(c);
    }

    public Resource addResource(Resource resource) {
        this._resources.addElement(resource);
        return resource;
    }

    public Resource addResourceDiscrete(int capacity, int avmin, int avmax, String name) {
        ResourceDiscrete resource = new ResourceDiscrete(this, avmin, avmax, capacity);
        resource.setName(name);
        this._resources.addElement(resource);
        return resource;
    }

    public Resource addResourceDiscrete(int capacity, String name) {
        ResourceDiscrete resource = new ResourceDiscrete(this, capacity);
        resource.setName(name);
        this._resources.addElement(resource);
        return resource;
    }

    public Resource addResourceUnary(int avmin, int avmax, String name) {
        ResourceUnary resource = new ResourceUnary(this, avmin, avmax);
        resource.setName(name);
        this._resources.addElement(resource);
        return resource;
    }

    public Resource addResourceUnary(String name) {
        ResourceUnary resource = new ResourceUnary(this);
        resource.setName(name);
        this._resources.addElement(resource);
        return resource;
    }

    public Constrainer constrainer() {
        return this._constrainer;
    }

    public int end() {
        return this._scheduleEnd;
    }

    public Job[] getAssignedJobs(Resource res) {
        int i;
        FastVector v = new FastVector(this._requirements.size());
        for (i = 0; i < this._requirements.size(); ++i) {
            AlternativeResourceConstraint c = (AlternativeResourceConstraint)this._requirements.elementAt(i);
            if (!res.equals(c.getResource())) continue;
            v.add(c.getJob());
        }
        Job[] jobs = new Job[v.size()];
        for (i = 0; i < this._requirements.size(); ++i) {
            jobs[i] = (Job)v.elementAt(i);
        }
        return jobs;
    }

    public Resource[] getAssignedResources(Job job) {
        int i;
        FastVector v = new FastVector(this._requirements.size());
        for (i = 0; i < this._requirements.size(); ++i) {
            Resource r;
            AlternativeResourceConstraint c = (AlternativeResourceConstraint)this._requirements.elementAt(i);
            if (!job.equals(c.getJob()) || (r = c.getResource()) == null) continue;
            v.add(r);
        }
        Resource[] res = new Resource[v.size()];
        for (i = 0; i < this._requirements.size(); ++i) {
            res[i] = (Resource)v.elementAt(i);
        }
        return res;
    }

    public String getAssignments(Job job) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this._requirements.size(); ++i) {
            Resource r;
            AlternativeResourceConstraint c = (AlternativeResourceConstraint)this._requirements.elementAt(i);
            if (!job.equals(c.getJob()) || (r = c.getResource()) == null) continue;
            str.append(r.getName() + "(" + c.getCapacity() + ") ");
        }
        return str.toString();
    }

    public String getAssignments(Resource res) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this._requirements.size(); ++i) {
            AlternativeResourceConstraint c = (AlternativeResourceConstraint)this._requirements.elementAt(i);
            if (!res.equals(c.getResource())) continue;
            str.append(c.getJob().getName() + " ");
        }
        return str.toString();
    }

    public String getName() {
        return this._name;
    }

    public FastVector jobs() {
        return this._jobs;
    }

    public FastVector resources() {
        return this._resources;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int size() {
        return this._scheduleEnd - this._scheduleStart;
    }

    public int start() {
        return this._scheduleStart;
    }

    public String toString() {
        return "Schedule: " + this._name + " [" + this._scheduleStart + ";" + this._scheduleEnd + ")" + "\nJobs: " + this._jobs.size() + "\nResources: " + this._resources.size() + "\nRequirements: " + this._requirements.size();
    }
}

