/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.simplex;

import org.openl.ie.simplex.VarType;

public class LPConstraint
extends VarType {
    private int[] _locations;
    private double[] _values;

    public LPConstraint(int[] locs, double[] vals) {
        if (locs.length != vals.length) {
            throw new IllegalArgumentException("Array \"vals\" must be of the same length as \"locs\" ");
        }
        this._locations = locs;
        this._values = vals;
    }

    public LPConstraint(int[] locs, double[] vals, int type, double lb) {
        this(locs, vals, type, lb, Double.MAX_VALUE);
    }

    public LPConstraint(int[] locs, double[] vals, int type, double lb, double ub) {
        super(type, lb, ub);
        if (locs.length != vals.length) {
            throw new IllegalArgumentException("Array \"vals\" must be of the same length as \"locs\" ");
        }
        for (int i = 0; i < locs.length; ++i) {
            if (locs[i] < 0) {
                throw new IllegalArgumentException("locs[" + i + "]=" + locs[i] + " : can't be negative");
            }
            if (vals[i] != 0.0) continue;
            throw new IllegalArgumentException("values[" + i + "]=0" + ": can't contain nill elements");
        }
        this._locations = locs;
        this._values = vals;
    }

    public int[] getLocations() {
        return this._locations;
    }

    public double[] getValues() {
        return this._values;
    }

    @Override
    public String toString() {
        String s = "[ ";
        s = s + super.toString();
        s = s + " MatRow: ";
        int size = this._locations.length - 1;
        for (int i = 0; i < size; ++i) {
            s = s + "" + this._locations[i] + ":" + this._values[i] + ", ";
        }
        s = s + this._locations[size] + ":" + this._values[size] + " ]";
        return s;
    }
}

