/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.cache;

import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public final class CacheKeyFactory {
    private CacheKeyFactory() {
    }

    public static Object createKey(Class<?> destClass, Class<?> srcClass) {
        return new CacheKey((Class)srcClass, (Class)destClass);
    }

    public static Object createKey(Class<?> destClass, Class<?> srcClass, String mapId) {
        return new CacheKey(srcClass, destClass, mapId);
    }

    private static class CacheKey {
        private Class<?> srcClass;
        private Class<?> destClass;
        private String mapId;

        private CacheKey(Class<?> srcClass, Class<?> destClass, String mapId) {
            this.srcClass = srcClass;
            this.destClass = destClass;
            this.mapId = mapId;
        }

        private CacheKey(Class<?> srcClass, Class<?> destClass) {
            this.srcClass = srcClass;
            this.destClass = destClass;
        }

        public boolean equals(Object o) {
            CacheKey cacheKey = (CacheKey)o;
            if (this.destClass != null ? !this.destClass.equals(cacheKey.destClass) : cacheKey.destClass != null) {
                return false;
            }
            if (this.srcClass != null ? !this.srcClass.equals(cacheKey.srcClass) : cacheKey.srcClass != null) {
                return false;
            }
            return !(this.mapId != null ? !this.mapId.equals(cacheKey.mapId) : cacheKey.mapId != null);
        }

        public int hashCode() {
            int result = this.srcClass != null ? this.srcClass.hashCode() : 0;
            result = 31 * result + (this.destClass != null ? this.destClass.hashCode() : 0);
            result = 31 * result + (this.mapId != null ? this.mapId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        }
    }
}

