/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.classmap;

import org.apache.commons.lang.StringUtils;
import org.dozer.util.MappingUtils;

public final class ClassMapKeyFactory {
    public String createKey(Class<?> srcClass, Class<?> destClass) {
        return this.createKey(srcClass, destClass, null);
    }

    public String createKey(Class<?> srcClass, Class<?> destClass, String mapId) {
        Class<?> srcRealClass = MappingUtils.getRealClass(srcClass);
        Class<?> destRealClass = MappingUtils.getRealClass(destClass);
        StringBuilder result = new StringBuilder(140);
        result.append("SRC-CLASS->");
        result.append(srcRealClass.getName());
        result.append(" DST-CLASS->");
        result.append(destRealClass.getName());
        if (StringUtils.isNotEmpty((String)mapId)) {
            result.append(" MAP-ID->");
            result.append(mapId);
        }
        return result.toString();
    }
}

