/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.converters;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dozer.converters.CustomConverterDescription;

public class CustomConverterContainer {
    private List<CustomConverterDescription> converters = new ArrayList<CustomConverterDescription>();

    public List<CustomConverterDescription> getConverters() {
        return this.converters;
    }

    public void setConverters(List<CustomConverterDescription> converters) {
        if (converters == null) {
            throw new IllegalArgumentException("Converters can not be null!");
        }
        this.converters = converters;
    }

    public void addConverter(CustomConverterDescription converter) {
        this.getConverters().add(converter);
    }

    public CustomConverterDescription getCustomConverter(Class<?> srcClass, Class<?> destClass) {
        if (this.converters.isEmpty()) {
            return null;
        }
        Class src = ClassUtils.primitiveToWrapper(srcClass);
        Class dest = ClassUtils.primitiveToWrapper(destClass);
        return this.findConverter(src, dest);
    }

    private CustomConverterDescription findConverter(Class<?> src, Class<?> dest) {
        for (CustomConverterDescription customConverter : this.converters) {
            Class classA = ClassUtils.primitiveToWrapper(customConverter.getClassA());
            Class classB = ClassUtils.primitiveToWrapper(customConverter.getClassB());
            if ((!classA.isAssignableFrom(dest) || !classB.isAssignableFrom(src)) && (!classA.isAssignableFrom(src) || !classB.isAssignableFrom(dest))) continue;
            return customConverter;
        }
        return null;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

