/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.fieldmap;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dozer.util.MappingUtils;

public class HintContainer {
    private String hintName;
    private List<Class<?>> hints;

    public Class<?> getHint() {
        if (this.hasMoreThanOneHint()) {
            return null;
        }
        Class<?> result = this.getHints().get(0);
        return result;
    }

    public Class<?> getHint(int index) {
        return this.getHints().get(index);
    }

    public boolean hasMoreThanOneHint() {
        return this.getHints().size() > 1;
    }

    public boolean hasHintType(int index) {
        return index < this.getHints().size() && this.getHint(index) != null;
    }

    public List<Class<?>> getHints() {
        if (this.hints == null) {
            ArrayList list = new ArrayList();
            if (!MappingUtils.isBlankOrNull(this.hintName)) {
                String[] tokens = this.hintName.split(",");
                for (int i = 0; i < tokens.length; ++i) {
                    String theHintName = tokens[i];
                    Class<?> clazz = null;
                    if (!MappingUtils.isBlankOrNull(theHintName)) {
                        clazz = MappingUtils.loadClass(theHintName.trim());
                    }
                    list.add(clazz);
                }
            }
            this.hints = list;
        }
        return this.hints;
    }

    public Class<?> getHint(Class<?> clazz, List<Class<?>> clazzHints) {
        List<Class<?>> hintTypes = this.getHints();
        int hintsSize = hintTypes.size();
        if (hintsSize == 1) {
            return this.getHint();
        }
        if (clazzHints.size() != hintsSize) {
            MappingUtils.throwMappingException("When using multiple source and destination hints there must be exactly the same number of hints on the source and the destination.");
        }
        int count = 0;
        String myClazName = MappingUtils.getRealClass(clazz).getName();
        int size = clazzHints.size();
        for (int i = 0; i < size; ++i) {
            Class<?> element = clazzHints.get(i);
            if (element.getName().equals(myClazName)) {
                return hintTypes.get(count);
            }
            ++count;
        }
        return clazz;
    }

    public void setHintName(String hintName) {
        this.hintName = hintName;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

