/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.loader;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dozer.CustomConverter;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.CopyByReference;
import org.dozer.classmap.DozerClass;
import org.dozer.classmap.MappingDirection;
import org.dozer.classmap.MappingFileData;
import org.dozer.classmap.RelationshipType;
import org.dozer.converters.CustomConverterDescription;
import org.dozer.converters.InstanceCustomConverterDescription;
import org.dozer.converters.JavaClassCustomConverterDescription;
import org.dozer.fieldmap.CustomGetSetMethodFieldMap;
import org.dozer.fieldmap.DozerField;
import org.dozer.fieldmap.EmptySourceFieldMap;
import org.dozer.fieldmap.ExcludeFieldMap;
import org.dozer.fieldmap.FieldMap;
import org.dozer.fieldmap.FieldMapUtils;
import org.dozer.fieldmap.GenericFieldMap;
import org.dozer.fieldmap.HintContainer;
import org.dozer.fieldmap.MapFieldMap;
import org.dozer.fieldmap.MultiSourceFieldMap;
import org.dozer.util.DozerConstants;
import org.dozer.util.MappingUtils;

public class DozerBuilder {
    private final List<MappingBuilder> mappingBuilders = new ArrayList<MappingBuilder>();
    MappingFileData data = new MappingFileData();

    private static DozerField prepareField(String name, String type) {
        String fieldType = null;
        String fieldName = DozerBuilder.isIndexed(name) ? DozerBuilder.getFieldNameOfIndexedField(name) : name;
        if (StringUtils.isNotEmpty((String)type)) {
            fieldType = type;
        }
        DozerField field = new DozerField(fieldName, fieldType);
        if (DozerBuilder.isIndexed(name)) {
            field.setIndexed(true);
            field.setIndex(DozerBuilder.getIndexOfIndexedField(name));
        }
        return field;
    }

    private static boolean isIndexed(String fieldName) {
        return fieldName != null && fieldName.matches(".+\\[.+?\\]$");
    }

    static String getFieldNameOfIndexedField(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        return fieldName.substring(0, fieldName.lastIndexOf(91));
    }

    private static String getIndexOfIndexedField(String fieldName) {
        return fieldName.substring(fieldName.lastIndexOf(91) + 1, fieldName.lastIndexOf(93));
    }

    public MappingFileData build() {
        for (MappingBuilder builder : this.mappingBuilders) {
            builder.build();
        }
        return this.data;
    }

    public ConfigurationBuilder configuration() {
        Configuration configuration = new Configuration();
        this.data.setConfiguration(configuration);
        return new ConfigurationBuilder(configuration);
    }

    public MappingBuilder mapping() {
        Configuration configuration = this.data.getConfiguration();
        ClassMap classMap = new ClassMap(configuration);
        this.data.getClassMaps().add(classMap);
        MappingBuilder mappingDefinitionBuilder = new MappingBuilder(classMap);
        this.mappingBuilders.add(mappingDefinitionBuilder);
        return mappingDefinitionBuilder;
    }

    public static class CustomConverterBuilder {
        private CustomConverterDescription converterDescription;

        public CustomConverterBuilder(CustomConverterDescription converterDescription) {
            this.converterDescription = converterDescription;
        }

        public CustomConverterBuilder classA(String type) {
            Class<?> aClass = MappingUtils.loadClass(type);
            return this.classA(aClass);
        }

        public CustomConverterBuilder classA(Class<?> type) {
            this.converterDescription.setClassA(type);
            return this;
        }

        public CustomConverterBuilder classB(String type) {
            Class<?> aClass = MappingUtils.loadClass(type);
            return this.classB(aClass);
        }

        public CustomConverterBuilder classB(Class<?> type) {
            this.converterDescription.setClassB(type);
            return this;
        }
    }

    public static class ConfigurationBuilder {
        private Configuration configuration;
        private CustomConverterDescription converterDescription;

        public ConfigurationBuilder(Configuration configuration) {
            this.configuration = configuration;
        }

        public void stopOnErrors(Boolean value) {
            this.configuration.setStopOnErrors(value);
        }

        public void dateFormat(String format) {
            this.configuration.setDateFormat(format);
        }

        public void wildcard(Boolean value) {
            this.configuration.setWildcard(value);
        }

        public void trimStrings(Boolean value) {
            this.configuration.setTrimStrings(value);
        }

        public void mapNulls(Boolean value) {
            this.configuration.setMapNulls(value);
        }

        public void mapEmptyStrings(Boolean value) {
            this.configuration.setMapEmptyStrings(value);
        }

        public void requiredFields(Boolean value) {
            this.configuration.setRequiredFields(value);
        }

        public void relationshipType(RelationshipType value) {
            if (value == null) {
                this.configuration.setRelationshipType(DozerConstants.DEFAULT_RELATIONSHIP_TYPE_POLICY);
            } else {
                this.configuration.setRelationshipType(value);
            }
        }

        public void beanFactory(String name) {
            this.configuration.setBeanFactory(name);
        }

        public CustomConverterBuilder customConverter(String type) {
            Class<?> aClass = MappingUtils.loadClass(type);
            return this.customConverter(aClass);
        }

        public CustomConverterBuilder customConverter(Class<? extends CustomConverter> type) {
            this.converterDescription = new JavaClassCustomConverterDescription();
            ((JavaClassCustomConverterDescription)this.converterDescription).setType(type);
            return this.customConverter(this.converterDescription);
        }

        public CustomConverterBuilder customConverter(CustomConverter customConverter) {
            this.converterDescription = new InstanceCustomConverterDescription();
            ((InstanceCustomConverterDescription)this.converterDescription).setInstance(customConverter);
            return this.customConverter(this.converterDescription);
        }

        private CustomConverterBuilder customConverter(CustomConverterDescription converterDescription) {
            this.configuration.getCustomConverters().addConverter(converterDescription);
            return new CustomConverterBuilder(converterDescription);
        }

        public ConfigurationBuilder copyByReference(String typeMask) {
            CopyByReference copyByReference = new CopyByReference(typeMask);
            this.configuration.getCopyByReferences().add(copyByReference);
            return this;
        }

        public ConfigurationBuilder allowedException(String type) {
            Class<?> exceptionType = MappingUtils.loadClass(type);
            return this.allowedException(exceptionType);
        }

        public ConfigurationBuilder allowedException(Class type) {
            if (!RuntimeException.class.isAssignableFrom(type)) {
                MappingUtils.throwMappingException("allowed-exception Type must extend java.lang.RuntimeException: " + type.getName());
            }
            this.configuration.getAllowedExceptions().getExceptions().add(type);
            return this;
        }
    }

    public static class ClassDefinitionBuilder {
        private DozerClass definition;

        public ClassDefinitionBuilder(DozerClass definition) {
            this.definition = definition;
        }

        public void mapGetMethod(String name) {
            this.definition.setMapGetMethod(name);
        }

        public void mapSetMethod(String name) {
            this.definition.setMapSetMethod(name);
        }

        public void beanFactory(String beanFactory) {
            this.definition.setBeanFactory(beanFactory);
        }

        public void factoryBeanId(String id) {
            this.definition.setFactoryBeanId(id);
        }

        public void createMethod(String name) {
            this.definition.setCreateMethod(name);
        }

        public void mapNull(Boolean value) {
            this.definition.setMapNull(value);
        }

        public void mapEmptyString(Boolean value) {
            this.definition.setMapEmptyString(value);
        }

        public void isAccessible(Boolean value) {
            this.definition.setAccessible(value);
        }
    }

    public static class FieldDefinitionBuilder {
        private DozerField field;

        public FieldDefinitionBuilder(DozerField field) {
            this.field = field;
        }

        public void dateFormat(String attribute) {
            this.field.setDateFormat(attribute);
        }

        public void theGetMethod(String attribute) {
            this.field.setTheGetMethod(attribute);
        }

        public void theSetMethod(String attribute) {
            this.field.setTheSetMethod(attribute);
        }

        public void mapGetMethod(String attribute) {
            this.field.setMapGetMethod(attribute);
        }

        public void mapSetMethod(String attribute) {
            this.field.setMapSetMethod(attribute);
        }

        public void key(String attribute) {
            this.field.setKey(attribute);
        }

        public void createMethod(String attribute) {
            this.field.setCreateMethod(attribute);
        }

        public void accessible(Boolean b) {
            this.field.setAccessible(b);
        }

        public void required(Boolean b) {
            this.field.setRequired(b);
        }

        public void defaultValue(String attribute) {
            this.field.setDefaultValue(attribute);
        }

        public void hint(String types) {
            HintContainer hintContainer = FieldMapUtils.hint(types);
            this.field.setHintContainer(hintContainer);
        }

        public void deepHint(String types) {
            HintContainer hintContainer = FieldMapUtils.hint(types);
            this.field.setDeepIndexHintContainer(hintContainer);
        }

        public void iterate() {
            this.field.setType("iterate");
        }

        public DozerField build() {
            return this.field;
        }
    }

    public static class FieldMappingBuilder
    implements FieldBuider {
        private ClassMap classMap;
        private List<DozerField> src = new ArrayList<DozerField>();
        private DozerField destField;
        private MappingDirection type;
        private RelationshipType relationshipType;
        private boolean removeOrphans;
        private boolean copyByReference;
        private String mapId;
        private String customConverter;
        private String customConverterId;
        private String customConverterParam;
        private boolean copyByReferenceSet;
        private String mappingCondition;
        private String mappingConditionId;
        private String collectionItemDiscriminator;
        private String collectionItemDiscriminatorId;
        private boolean mapNull;
        private boolean mapNullSet;
        private boolean mapEmptyString;
        private boolean mapEmptyStringSet;
        private boolean trimString;
        private boolean trimStringSet;

        public FieldMappingBuilder(ClassMap classMap) {
            this.classMap = classMap;
        }

        public FieldDefinitionBuilder a(String name) {
            return this.a(name, null);
        }

        @Override
        public FieldDefinitionBuilder a(String name, String type) {
            DozerField field = DozerBuilder.prepareField(name, type);
            this.src.add(field);
            return new FieldDefinitionBuilder(field);
        }

        public FieldDefinitionBuilder b(String name) {
            return this.b(name, null);
        }

        @Override
        public FieldDefinitionBuilder b(String name, String type) {
            DozerField field;
            this.destField = field = DozerBuilder.prepareField(name, type);
            return new FieldDefinitionBuilder(field);
        }

        public void type(MappingDirection type) {
            this.type = type;
        }

        public void relationshipType(RelationshipType relationshipType) {
            this.relationshipType = relationshipType;
        }

        public void removeOrphans(boolean value) {
            this.removeOrphans = value;
        }

        public void copyByReference(boolean value) {
            this.copyByReferenceSet = true;
            this.copyByReference = value;
        }

        public void mapId(String attribute) {
            this.mapId = attribute;
        }

        public void customConverter(Class<? extends CustomConverter> type) {
            this.customConverter(type.getName());
        }

        public void customConverter(String typeName) {
            this.customConverter = typeName;
        }

        public void customConverterId(String attribute) {
            this.customConverterId = attribute;
        }

        public void customConverterParam(String attribute) {
            this.customConverterParam = attribute;
        }

        public void mappingCondition(String typeName) {
            this.mappingCondition = typeName;
        }

        public void mappingConditionId(String attribute) {
            this.mappingConditionId = attribute;
        }

        public void collectionItemDiscriminator(String discriminator) {
            this.collectionItemDiscriminator = discriminator;
        }

        public void collectionItemDiscriminatorId(String id) {
            this.collectionItemDiscriminatorId = id;
        }

        public void mapNull(boolean value) {
            this.mapNullSet = true;
            this.mapNull = value;
        }

        public void mapEmptyString(boolean value) {
            this.mapEmptyStringSet = true;
            this.mapEmptyString = value;
        }

        public void trimString(boolean value) {
            this.trimStringSet = true;
            this.trimString = value;
        }

        @Override
        public void build() {
            FieldMap result;
            if (this.src.size() > 1) {
                result = new MultiSourceFieldMap(this.classMap);
                ((MultiSourceFieldMap)result).setSrc(this.src);
            } else {
                DozerField srcField = this.src.get(0);
                result = srcField.isMapTypeCustomGetterSetterField() || this.destField.isMapTypeCustomGetterSetterField() || this.classMap.isSrcClassMapTypeCustomGetterSetter() || this.classMap.isDestClassMapTypeCustomGetterSetter() ? new MapFieldMap(this.classMap) : (srcField.isCustomGetterSetterField() || this.destField.isCustomGetterSetterField() ? new CustomGetSetMethodFieldMap(this.classMap) : (MappingUtils.isBlankOrNull(srcField.getName()) ? new EmptySourceFieldMap(this.classMap) : new GenericFieldMap(this.classMap)));
                result.setSrcField(srcField);
            }
            result.setDestField(this.destField);
            result.setType(this.type);
            result.setRelationshipType(this.relationshipType);
            result.setRemoveOrphans(this.removeOrphans);
            if (this.copyByReferenceSet) {
                result.setCopyByReference(this.copyByReference);
            }
            result.setMapId(this.mapId);
            result.setCustomConverter(this.customConverter);
            result.setCustomConverterId(this.customConverterId);
            result.setCustomConverterParam(this.customConverterParam);
            result.setMappingCondition(this.mappingCondition);
            result.setMappingConditionId(this.mappingConditionId);
            result.setCollectionItemDiscriminator(this.collectionItemDiscriminator);
            result.setCollectionItemDiscriminatorId(this.collectionItemDiscriminatorId);
            if (this.mapNullSet) {
                result.setMapNull(this.mapNull);
            }
            if (this.mapEmptyStringSet) {
                result.setMapEmptyString(this.mapEmptyString);
            }
            if (this.trimStringSet) {
                result.setTrimString(this.trimString);
            }
            this.classMap.addFieldMapping(result);
        }
    }

    public static class FieldExclusionBuilder
    implements FieldBuider {
        private ExcludeFieldMap fieldMap;

        public FieldExclusionBuilder(ExcludeFieldMap fieldMap) {
            this.fieldMap = fieldMap;
        }

        public void type(MappingDirection type) {
            this.fieldMap.setType(type);
        }

        @Override
        public FieldDefinitionBuilder a(String name, String type) {
            DozerField field = DozerBuilder.prepareField(name, type);
            this.fieldMap.setSrcField(field);
            return new FieldDefinitionBuilder(field);
        }

        @Override
        public FieldDefinitionBuilder b(String name, String type) {
            DozerField field = DozerBuilder.prepareField(name, type);
            this.fieldMap.setDestField(field);
            return new FieldDefinitionBuilder(field);
        }

        @Override
        public void build() {
            ClassMap classMap = this.fieldMap.getClassMap();
            classMap.addFieldMapping(this.fieldMap);
        }
    }

    public static class MappingBuilder {
        private final List<FieldBuider> fieldBuilders = new ArrayList<FieldBuider>();
        private ClassMap classMap;

        public MappingBuilder(ClassMap classMap) {
            this.classMap = classMap;
        }

        public MappingBuilder dateFormat(String dateFormat) {
            this.classMap.setDateFormat(dateFormat);
            return this;
        }

        public MappingBuilder mapNull(boolean value) {
            this.classMap.setMapNull(value);
            return this;
        }

        public MappingBuilder mapEmptyString(boolean value) {
            this.classMap.setMapEmptyString(value);
            return this;
        }

        public MappingBuilder beanFactory(String typeName) {
            this.classMap.setBeanFactory(typeName);
            return this;
        }

        public MappingBuilder relationshipType(RelationshipType type) {
            this.classMap.setRelationshipType(type);
            return this;
        }

        public MappingBuilder wildcard(Boolean value) {
            this.classMap.setWildcard(value);
            return this;
        }

        public MappingBuilder trimStrings(Boolean value) {
            this.classMap.setTrimStrings(value);
            return this;
        }

        public MappingBuilder requiredFields(Boolean value) {
            this.classMap.setRequiredFields(value);
            return this;
        }

        public MappingBuilder stopOnErrors(Boolean value) {
            this.classMap.setStopOnErrors(value);
            return this;
        }

        public MappingBuilder mapId(String id) {
            this.classMap.setMapId(id);
            return this;
        }

        public MappingBuilder type(MappingDirection type) {
            this.classMap.setType(type);
            return this;
        }

        public ClassDefinitionBuilder classA(String typeName) {
            Class<?> type = MappingUtils.loadClass(typeName);
            return this.classA(type);
        }

        public ClassDefinitionBuilder classA(Class<?> type) {
            DozerClass classDefinition = new DozerClass();
            classDefinition.setName(type.getName());
            this.classMap.setSrcClass(classDefinition);
            return new ClassDefinitionBuilder(classDefinition);
        }

        public ClassDefinitionBuilder classB(String typeName) {
            Class<?> type = MappingUtils.loadClass(typeName);
            return this.classB(type);
        }

        public ClassDefinitionBuilder classB(Class<?> type) {
            DozerClass classDefinition = new DozerClass();
            classDefinition.setName(type.getName());
            this.classMap.setDestClass(classDefinition);
            return new ClassDefinitionBuilder(classDefinition);
        }

        public FieldExclusionBuilder fieldExclude() {
            ExcludeFieldMap excludeFieldMap = new ExcludeFieldMap(this.classMap);
            FieldExclusionBuilder builder = new FieldExclusionBuilder(excludeFieldMap);
            this.fieldBuilders.add(builder);
            return builder;
        }

        public FieldMappingBuilder field() {
            FieldMappingBuilder builder = new FieldMappingBuilder(this.classMap);
            this.fieldBuilders.add(builder);
            return builder;
        }

        public void build() {
            for (FieldBuider builder : this.fieldBuilders) {
                builder.build();
            }
        }
    }

    public static interface FieldBuider {
        public FieldDefinitionBuilder a(String var1, String var2);

        public FieldDefinitionBuilder b(String var1, String var2);

        public void build();
    }
}

