/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.propertydescriptor;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import org.dozer.MappingException;
import org.dozer.factory.BeanCreationDirective;
import org.dozer.factory.DestBeanCreator;
import org.dozer.fieldmap.FieldMap;
import org.dozer.fieldmap.HintContainer;
import org.dozer.propertydescriptor.AbstractPropertyDescriptor;
import org.dozer.propertydescriptor.DeepHierarchyElement;
import org.dozer.util.BridgedMethodFinder;
import org.dozer.util.CollectionUtils;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;
import org.dozer.util.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GetterSetterPropertyDescriptor
extends AbstractPropertyDescriptor {
    private static final Logger log = LoggerFactory.getLogger(GetterSetterPropertyDescriptor.class);
    private Class<?> propertyType;

    public GetterSetterPropertyDescriptor(Class<?> clazz, String fieldName, boolean isIndexed, String index, HintContainer deepIndexHintContainer) {
        super(clazz, fieldName, isIndexed, index, deepIndexHintContainer);
    }

    public abstract Method getWriteMethod() throws NoSuchMethodException;

    protected abstract Method getReadMethod() throws NoSuchMethodException;

    protected abstract String getSetMethodName() throws NoSuchMethodException;

    protected abstract boolean isCustomSetMethod();

    @Override
    public Class<?> getPropertyType() {
        if (this.propertyType == null) {
            this.propertyType = this.determinePropertyType();
        }
        return this.propertyType;
    }

    @Override
    public Object getPropertyValue(Object bean) {
        Object result;
        if (MappingUtils.isDeepMapping(this.fieldName)) {
            result = this.getDeepSrcFieldValue(bean);
        } else {
            result = this.invokeReadMethod(bean);
            if (this.isIndexed) {
                if (MappingUtils.isSimpleCollectionIndex(this.index)) {
                    int collectionIndex = MappingUtils.getCollectionIndex(this.index);
                    result = MappingUtils.getCollectionIndexedValue(result, collectionIndex);
                } else {
                    String expression = String.format("%s[%s]", this.fieldName, this.index);
                    result = MappingUtils.getXPathIndexedValue(bean, expression);
                }
            }
        }
        return result;
    }

    @Override
    public void setPropertyValue(Object bean, Object value, FieldMap fieldMap) {
        if (MappingUtils.isDeepMapping(this.fieldName)) {
            this.writeDeepDestinationValue(bean, value, fieldMap);
        } else if (!this.getPropertyType().isPrimitive() || value != null) {
            if (this.isIndexed) {
                this.writeIndexedValue(bean, value);
            } else {
                try {
                    if (this.getPropertyValue(bean) == value && !this.isIndexed) {
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.invokeWriteMethod(bean, value);
            }
        }
    }

    private Object getDeepSrcFieldValue(Object srcObj) {
        Object parentObj;
        Object hierarchyValue = parentObj = srcObj;
        DeepHierarchyElement[] hierarchy = this.getDeepFieldHierarchy(srcObj, this.deepIndexHintContainer);
        int hierarchyLength = hierarchy.length;
        for (int i = 0; i < hierarchyLength; ++i) {
            DeepHierarchyElement hierarchyElement = hierarchy[i];
            PropertyDescriptor pd = hierarchyElement.getPropDescriptor();
            if (!MappingUtils.isBlankOrNull(hierarchyElement.getIndex())) {
                Object bean = ReflectionUtils.invoke(pd.getReadMethod(), hierarchyValue, null);
                if (MappingUtils.isSimpleCollectionIndex(hierarchyElement.getIndex())) {
                    int collectionIndex = MappingUtils.getCollectionIndex(hierarchyElement.getIndex());
                    hierarchyValue = MappingUtils.getCollectionIndexedValue(bean, collectionIndex);
                } else {
                    String expression = String.format("%s[%s]", pd.getName(), hierarchyElement.getIndex());
                    hierarchyValue = MappingUtils.getXPathIndexedValue(parentObj, expression);
                }
            } else {
                hierarchyValue = ReflectionUtils.invoke(pd.getReadMethod(), parentObj, null);
            }
            if (hierarchyValue == null) {
                return null;
            }
            if (i == hierarchyLength - 1) continue;
            parentObj = hierarchyValue;
        }
        if (this.isIndexed) {
            if (MappingUtils.isSimpleCollectionIndex(this.index)) {
                int collectionIndex = MappingUtils.getCollectionIndex(this.index);
                hierarchyValue = MappingUtils.getCollectionIndexedValue(hierarchyValue, collectionIndex);
            } else {
                String lastFieldName = hierarchy[hierarchyLength - 1].getPropDescriptor().getName();
                String expression = String.format("%s[%s]", lastFieldName, this.index);
                hierarchyValue = MappingUtils.getXPathIndexedValue(parentObj, expression);
            }
        }
        return hierarchyValue;
    }

    protected void writeDeepDestinationValue(Object destObj, Object destFieldValue, FieldMap fieldMap) {
        DeepHierarchyElement[] hierarchy = this.getDeepFieldHierarchy(destObj, fieldMap.getDestDeepIndexHintContainer());
        Object parentObj = destObj;
        int hierarchyLength = hierarchy.length - 1;
        for (int i = 0; i < hierarchyLength; ++i) {
            Class<?> hintType;
            int collectionIndex;
            String index;
            DeepHierarchyElement hierarchyElement = hierarchy[i];
            PropertyDescriptor pd = hierarchyElement.getPropDescriptor();
            Object value = ReflectionUtils.invoke(pd.getReadMethod(), parentObj, null);
            if (value == null) {
                Class<?> clazz = pd.getPropertyType();
                if (clazz.isInterface() && i + 1 == hierarchyLength && fieldMap.getDestHintContainer() != null) {
                    clazz = fieldMap.getDestHintContainer().getHint();
                }
                Object o = null;
                if (clazz.isArray() || Collection.class.isAssignableFrom(clazz)) {
                    index = hierarchyElement.getIndex();
                    if (!MappingUtils.isSimpleCollectionIndex(index)) {
                        MappingUtils.throwMappingException(String.format("Destination field '%s' should be indexed or should not contain filter expressions", hierarchyElement.getPropDescriptor().getName()));
                    }
                    collectionIndex = MappingUtils.getCollectionIndex(index);
                    if (clazz.isArray()) {
                        o = MappingUtils.prepareIndexedCollection(clazz, null, DestBeanCreator.create(null, clazz.getComponentType()), collectionIndex);
                    }
                    if (Collection.class.isAssignableFrom(clazz)) {
                        hintType = null;
                        if (fieldMap.getDestDeepIndexHintContainer() != null) {
                            hintType = fieldMap.getDestDeepIndexHintContainer().getHint(i);
                        }
                        Class<?> collectionEntryType = ReflectionUtils.getComponentType(clazz, pd, hintType);
                        o = MappingUtils.prepareIndexedCollection(clazz, null, DestBeanCreator.create(null, collectionEntryType), collectionIndex);
                    }
                } else {
                    if (fieldMap.getDestDeepIndexHintContainer() != null && fieldMap.getDestDeepIndexHintContainer().hasHintType(i)) {
                        clazz = fieldMap.getDestDeepIndexHintContainer().getHint(i);
                    }
                    try {
                        o = DestBeanCreator.create(null, clazz);
                    }
                    catch (Exception e) {
                        if (fieldMap.getClassMap().getDestClassBeanFactory() != null) {
                            o = DestBeanCreator.create(null, new BeanCreationDirective(null, fieldMap.getClassMap().getSrcClassToMap(), clazz, clazz, fieldMap.getClassMap().getDestClassBeanFactory(), fieldMap.getClassMap().getDestClassBeanFactoryId(), null));
                        }
                        MappingUtils.throwMappingException(e);
                    }
                }
                ReflectionUtils.invoke(pd.getWriteMethod(), parentObj, new Object[]{o});
                value = ReflectionUtils.invoke(pd.getReadMethod(), parentObj, null);
            }
            if (MappingUtils.isSupportedCollection(value.getClass())) {
                int currentSize = CollectionUtils.getLengthOfCollection(value);
                index = hierarchyElement.getIndex();
                if (!MappingUtils.isSimpleCollectionIndex(index)) {
                    MappingUtils.throwMappingException("Destination field path should not contain filter expressions");
                }
                if (currentSize < (collectionIndex = MappingUtils.getCollectionIndex(index)) + 1 || MappingUtils.getCollectionIndexedValue(value, collectionIndex) == null) {
                    hintType = null;
                    if (fieldMap.getDestDeepIndexHintContainer() != null) {
                        hintType = fieldMap.getDestDeepIndexHintContainer().getHint(i);
                    }
                    Class<?> componentType = ReflectionUtils.getComponentType(pd.getPropertyType(), pd, hintType);
                    value = MappingUtils.prepareIndexedCollection(pd.getPropertyType(), value, DestBeanCreator.create(null, componentType), collectionIndex);
                    ReflectionUtils.invoke(pd.getWriteMethod(), parentObj, new Object[]{value});
                    value = ReflectionUtils.invoke(pd.getReadMethod(), parentObj, null);
                }
            }
            if (value != null && (value.getClass().isArray() || Collection.class.isAssignableFrom(value.getClass()))) {
                String index2 = hierarchyElement.getIndex();
                if (!MappingUtils.isSimpleCollectionIndex(index2)) {
                    MappingUtils.throwMappingException("Destination field path should not contain filter expressions");
                }
                parentObj = MappingUtils.getCollectionIndexedValue(value, MappingUtils.getCollectionIndex(index2));
                continue;
            }
            parentObj = value;
        }
        PropertyDescriptor pd = hierarchy[hierarchy.length - 1].getPropDescriptor();
        Class<?> type = pd.getReadMethod() != null ? pd.getReadMethod().getReturnType() : pd.getWriteMethod().getParameterTypes()[0];
        if (!type.isPrimitive() || destFieldValue != null) {
            if (!this.isIndexed) {
                Method method = null;
                if (!this.isCustomSetMethod()) {
                    method = pd.getWriteMethod();
                } else {
                    try {
                        method = ReflectionUtils.findAMethod(parentObj.getClass(), this.getSetMethodName());
                    }
                    catch (NoSuchMethodException e) {
                        MappingUtils.throwMappingException(e);
                    }
                }
                ReflectionUtils.invoke(method, parentObj, new Object[]{destFieldValue});
            } else {
                this.writeIndexedValue(parentObj, destFieldValue);
            }
        }
    }

    protected Object invokeReadMethod(Object target) {
        Object result = null;
        try {
            result = ReflectionUtils.invoke(this.getReadMethod(), target, null);
        }
        catch (NoSuchMethodException e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }

    protected void invokeWriteMethod(Object target, Object value) {
        try {
            ReflectionUtils.invoke(this.getWriteMethod(), target, new Object[]{value});
        }
        catch (NoSuchMethodException e) {
            MappingUtils.throwMappingException(e);
        }
    }

    private DeepHierarchyElement[] getDeepFieldHierarchy(Object obj, HintContainer deepIndexHintContainer) {
        return ReflectionUtils.getDeepFieldHierarchy(obj.getClass(), this.fieldName, deepIndexHintContainer);
    }

    private void writeIndexedValue(Object destObj, Object destFieldValue) {
        if (!MappingUtils.isSimpleCollectionIndex(this.index)) {
            MappingUtils.throwMappingException("Destinaiton field path should not contain filter expressions");
        }
        if (MappingUtils.isSimpleCollectionIndex(this.index)) {
            int collectionIndex = MappingUtils.getCollectionIndex(this.index);
            Object existingValue = this.invokeReadMethod(destObj);
            if (collectionIndex == -1) {
                collectionIndex = existingValue != null ? CollectionUtils.getLengthOfCollection(existingValue) : 0;
            }
            this.writeIndexedValue(destObj, collectionIndex, existingValue, destFieldValue);
        }
    }

    private void writeIndexedValue(Object destObj, int collectionIndex, Object existingValue, Object destFieldValue) {
        Object indexedValue = MappingUtils.prepareIndexedCollection(this.getPropertyType(), existingValue, destFieldValue, collectionIndex);
        this.invokeWriteMethod(destObj, indexedValue);
    }

    private Class determinePropertyType() {
        Method readMethod = this.getBridgedReadMethod();
        Method writeMethod = this.getBridgedWriteMethod();
        Class<?> returnType = null;
        try {
            returnType = TypeResolver.resolvePropertyType(this.clazz, readMethod, writeMethod);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (returnType != null) {
            return returnType;
        }
        if (readMethod == null && writeMethod == null) {
            throw new MappingException("No read or write method found for field (" + this.fieldName + ") in class (" + this.clazz + ")");
        }
        if (readMethod == null) {
            return this.determineByWriteMethod(writeMethod);
        }
        try {
            return readMethod.getReturnType();
        }
        catch (Exception e) {
            return this.determineByWriteMethod(writeMethod);
        }
    }

    private Class determineByWriteMethod(Method writeMethod) {
        try {
            return writeMethod.getParameterTypes()[0];
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }

    private Method getBridgedReadMethod() {
        try {
            return BridgedMethodFinder.findMethod(this.getReadMethod(), this.clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Method getBridgedWriteMethod() {
        try {
            return BridgedMethodFinder.findMethod(this.getWriteMethod(), this.clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Class<?> genericType() {
        Class<?> genericType = null;
        try {
            Method method = this.getWriteMethod();
            genericType = ReflectionUtils.determineGenericsType(method, false);
        }
        catch (NoSuchMethodException e) {
            log.warn("The destination object: {} does not have a write method for property : {}", (Throwable)e);
        }
        return genericType;
    }
}

