/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.propertydescriptor;

import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import org.dozer.MappingException;
import org.dozer.fieldmap.FieldMap;
import org.dozer.fieldmap.HintContainer;
import org.dozer.propertydescriptor.GetterSetterPropertyDescriptor;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;

public class MapPropertyDescriptor
extends GetterSetterPropertyDescriptor {
    private final String setMethodName;
    private final String getMethodName;
    private final String key;
    private SoftReference<Method> writeMethod;
    private SoftReference<Method> readMethod;

    public MapPropertyDescriptor(Class<?> clazz, String fieldName, boolean isIndexed, String index, String setMethod, String getMethod, String key, HintContainer deepIndexHintContainer) {
        super(clazz, fieldName, isIndexed, index, deepIndexHintContainer);
        this.setMethodName = setMethod;
        this.getMethodName = getMethod;
        this.key = key;
    }

    @Override
    public Method getWriteMethod() throws NoSuchMethodException {
        if (MappingUtils.isBlankOrNull(this.setMethodName)) {
            throw new MappingException("Custom Map set method not specified for field mapping to class: " + this.clazz + ".  Perhaps the map-set-method wasn't specified in the dozer mapping file?");
        }
        if (this.writeMethod == null || this.writeMethod.get() == null) {
            Method method = this.findMapMethod(this.clazz, this.setMethodName, 2);
            this.writeMethod = new SoftReference<Method>(method);
        }
        return this.writeMethod.get();
    }

    private Method findMapMethod(Class clazz, String methodName, int parameterCount) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!methodName.equals(method.getName()) || method.getParameterTypes().length != parameterCount) continue;
            return method;
        }
        throw new MappingException("No map method found for class:" + clazz + " and method name:" + methodName);
    }

    @Override
    public void setPropertyValue(Object bean, Object value, FieldMap fieldMap) {
        if (MappingUtils.isDeepMapping(this.fieldName)) {
            this.writeDeepDestinationValue(bean, value, fieldMap);
        } else if (!this.getPropertyType().isPrimitive() || value != null) {
            try {
                if (value != null && this.getPropertyValue(bean) == value) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.invokeWriteMethod(bean, value);
        }
    }

    @Override
    protected Method getReadMethod() throws NoSuchMethodException {
        if (MappingUtils.isBlankOrNull(this.getMethodName)) {
            throw new MappingException("Custom Map get method not specified for field mapping to class: " + this.clazz + ".  Perhaps the map-get-method wasn't specified in the dozer mapping file?");
        }
        if (this.readMethod == null || this.readMethod.get() == null) {
            Method method = this.findMapMethod(this.clazz, this.getMethodName, 1);
            this.readMethod = new SoftReference<Method>(method);
        }
        return this.readMethod.get();
    }

    @Override
    protected String getSetMethodName() throws NoSuchMethodException {
        return this.setMethodName;
    }

    @Override
    protected boolean isCustomSetMethod() {
        return true;
    }

    @Override
    protected void invokeWriteMethod(Object target, Object value) {
        if (this.key == null) {
            throw new MappingException("key must be specified");
        }
        try {
            ReflectionUtils.invoke(this.getWriteMethod(), target, new Object[]{this.key, value});
        }
        catch (NoSuchMethodException e) {
            MappingUtils.throwMappingException(e);
        }
    }

    @Override
    protected Object invokeReadMethod(Object target) {
        if (this.key == null) {
            throw new MappingException("key must be specified");
        }
        Object result = null;
        try {
            result = ReflectionUtils.invoke(this.getReadMethod(), target, new Object[]{this.key});
        }
        catch (NoSuchMethodException e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }
}

