/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.util;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static boolean isArray(Class<?> aClass) {
        return aClass.isArray();
    }

    public static boolean isCollection(Class<?> aClass) {
        return Collection.class.isAssignableFrom(aClass);
    }

    public static boolean isList(Class<?> aClass) {
        return List.class.isAssignableFrom(aClass);
    }

    public static boolean isSet(Class<?> aClass) {
        return Set.class.isAssignableFrom(aClass);
    }

    public static boolean isPrimitiveArray(Class<?> aClass) {
        return aClass.isArray() && aClass.getComponentType().isPrimitive();
    }

    public static int getLengthOfCollection(Object value) {
        if (CollectionUtils.isArray(value.getClass())) {
            return Array.getLength(value);
        }
        return ((Collection)value).size();
    }

    public static Object getValueFromCollection(Object collection, int index) {
        if (CollectionUtils.isArray(collection.getClass())) {
            return Array.get(collection, index);
        }
        return ((Collection)collection).toArray()[index];
    }

    public static <T extends Set<?>> Set<?> createNewSet(Class<T> destType) {
        AbstractSet result = SortedSet.class.isAssignableFrom(destType) ? new TreeSet() : new HashSet();
        return result;
    }

    public static <T extends Set<?>> Set<?> createNewSet(Class<T> destSetType, Collection<?> srcValue) {
        Set<?> result = CollectionUtils.createNewSet(destSetType);
        if (srcValue != null) {
            result.addAll(srcValue);
        }
        return result;
    }

    public static <T> Object convertListToArray(List<T> list, Class<T> destEntryType) {
        Object outArray = Array.newInstance(destEntryType, list.size());
        int count = 0;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T element = list.get(i);
            Array.set(outArray, count, element);
            ++count;
        }
        if (destEntryType.isPrimitive()) {
            return outArray;
        }
        return (Object[])outArray;
    }

    public static List<Object> convertPrimitiveArrayToList(Object primitiveArray) {
        int length = Array.getLength(primitiveArray);
        ArrayList<Object> result = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            result.add(Array.get(primitiveArray, i));
        }
        return result;
    }
}

