/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.util;

import java.util.Collection;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dozer.fieldmap.FieldMap;
import org.dozer.fieldmap.MultiSourceFieldMap;
import org.dozer.util.MappingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogMsgFactory {
    private static final Logger log = LoggerFactory.getLogger(LogMsgFactory.class);

    private LogMsgFactory() {
    }

    public static String createFieldMappingErrorMsg(Object srcObj, FieldMap fieldMapping, Object srcFieldValue, Object destObj) {
        String srcValueType;
        String srcClassName = null;
        if (srcObj != null) {
            srcClassName = srcObj.getClass().getName();
        }
        String srcFieldValueString = null;
        if (srcFieldValue != null) {
            srcValueType = srcFieldValue.getClass().toString();
            try {
                srcFieldValueString = srcFieldValue.toString();
            }
            catch (Exception e) {
                log.error("An exception occurred invoking toString() on the source field value: " + srcFieldValue.getClass().getName() + "@" + Integer.toHexString(srcFieldValue.hashCode()), (Throwable)e);
                srcFieldValueString = "Unable to determine source field value";
            }
        } else {
            srcValueType = fieldMapping instanceof MultiSourceFieldMap ? Object[].class.getName() : fieldMapping.getSrcFieldType();
        }
        String destClassName = null;
        if (destObj != null) {
            destClassName = destObj.getClass().getName();
        }
        String destFieldTypeName = null;
        try {
            if (destObj != null) {
                destFieldTypeName = fieldMapping.getDestFieldType(destObj.getClass()).getName();
            }
        }
        catch (Exception e) {
            log.warn("Unable to determine dest field type when build log.error message");
        }
        return "Field mapping error -->\n  MapId: " + fieldMapping.getMapId() + "\n  Type: " + fieldMapping.getType() + "\n  Source parent class: " + srcClassName + "\n  Source field name: " + fieldMapping.getSrcFieldName() + "\n  Source field type: " + srcValueType + "\n  Source field value: " + srcFieldValueString + "\n  Dest parent class: " + destClassName + "\n  Dest field name: " + fieldMapping.getDestFieldName() + "\n  Dest field type: " + destFieldTypeName;
    }

    public static String createFieldMappingSuccessMsg(Class<?> srcClass, Class<?> destClass, String srcFieldName, String destFieldName, Object srcFieldValue, Object destFieldValue, String classMapId) {
        String srcClassStr = MappingUtils.getClassNameWithoutPackage(srcClass);
        String destClassStr = MappingUtils.getClassNameWithoutPackage(destClass);
        return "MAPPED: " + srcClassStr + "." + srcFieldName + " --> " + destClassStr + "." + destFieldName + "    VALUES: " + LogMsgFactory.getLogOutput(srcFieldValue) + " --> " + LogMsgFactory.getLogOutput(destFieldValue) + "    MAPID: " + (classMapId != null ? classMapId : "");
    }

    public static String getLogOutput(Object object) {
        String output = "NULL";
        if (object == null) {
            return output;
        }
        try {
            output = object.getClass().isArray() || Collection.class.isAssignableFrom(object.getClass()) ? ReflectionToStringBuilder.toString((Object)object, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE) : object.toString();
        }
        catch (RuntimeException e) {
            output = object.toString();
        }
        return output;
    }
}

