/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.binding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.binding.IBindingContext;
import org.openl.binding.ICastFactory;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.binding.impl.method.MethodSearch;
import org.openl.binding.impl.module.ModuleBindingContext;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLSystemProperties;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.binding.CustomDynamicOpenClass;
import org.openl.rules.binding.PreBinderMethods;
import org.openl.rules.binding.RecursiveMethodPreBindingException;
import org.openl.rules.binding.RecursiveOpenMethodPreBinder;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.context.RulesRuntimeContextDelegator;
import org.openl.rules.context.RulesRuntimeContextFactory;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.runtime.IRuntimeContext;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodCaller;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.CastingMethodCaller;
import org.openl.types.impl.MethodSignature;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.impl.ParameterDeclaration;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.CollectionUtils;
import org.openl.vm.IRuntimeEnv;
import org.slf4j.LoggerFactory;

public class RulesModuleBindingContext
extends ModuleBindingContext {
    public static String MODULE_PROPERTIES_KEY = "Properties:Module";
    public static String CATEGORY_PROPERTIES_KEY = "Properties:Category:";
    private Map<String, TableSyntaxNode> bindedTables = new HashMap<String, TableSyntaxNode>();
    private List<IOpenMethod> internalMethods;
    private PreBinderMethods preBinderMethods = new PreBinderMethods();

    public RulesModuleBindingContext(IBindingContext delegate, ModuleOpenClass module) {
        super(delegate, module);
        this.internalMethods = new ArrayList<IOpenMethod>();
        this.internalMethods.add(new CurrentRuntimeContextMethod());
        this.internalMethods.add(new EmptyRuntimeContextMethod());
        this.internalMethods.add(new RestoreRuntimeContextMethod());
        this.internalMethods.add(new SetRuntimeContextMethod());
        this.internalMethods.add(new ModifyRuntimeContextMethod());
    }

    public void registerTableSyntaxNode(String key, TableSyntaxNode tsn) {
        this.bindedTables.put(key, tsn);
    }

    public boolean isTableSyntaxNodeExist(String key) {
        return this.bindedTables.containsKey(key);
    }

    public TableSyntaxNode getTableSyntaxNode(String key) {
        return this.bindedTables.get(key);
    }

    public IMethodCaller findMethodCaller(String namespace, final String methodName, IOpenClass[] parTypes) throws AmbiguousMethodException {
        List select = CollectionUtils.findAll(this.preBinderMethods.values(), (CollectionUtils.Predicate)new CollectionUtils.Predicate<IOpenMethod>(){

            public boolean evaluate(IOpenMethod method) {
                return methodName.equals(method.getName());
            }
        });
        IMethodCaller method = MethodSearch.findMethod((String)methodName, (IOpenClass[])parTypes, (ICastFactory)this, (Iterable)select);
        if (method != null) {
            RecursiveOpenMethodPreBinder openMethodBinder = null;
            if (method instanceof RecursiveOpenMethodPreBinder) {
                openMethodBinder = (RecursiveOpenMethodPreBinder)method;
            }
            if (method instanceof CastingMethodCaller) {
                openMethodBinder = (RecursiveOpenMethodPreBinder)((CastingMethodCaller)method).getMethod();
            }
            method = null;
            if (openMethodBinder.isPreBinding()) {
                method = super.findMethodCaller(namespace, methodName, parTypes);
                if (method == null) {
                    List internalselect = CollectionUtils.findAll(this.internalMethods, (CollectionUtils.Predicate)new CollectionUtils.Predicate<IOpenMethod>(){

                        public boolean evaluate(IOpenMethod method) {
                            return methodName.equals(method.getName());
                        }
                    });
                    method = MethodSearch.findMethod((String)methodName, (IOpenClass[])parTypes, (ICastFactory)this, (Iterable)internalselect);
                }
                if (method != null) {
                    return method;
                }
                throw new RecursiveMethodPreBindingException();
            }
            openMethodBinder.preBind();
            this.preBinderMethods.remove((IOpenMethodHeader)openMethodBinder.getHeader());
        }
        if ((method = super.findMethodCaller(namespace, methodName, parTypes)) == null) {
            List internalselect = CollectionUtils.findAll(this.internalMethods, (CollectionUtils.Predicate)new CollectionUtils.Predicate<IOpenMethod>(){

                public boolean evaluate(IOpenMethod method) {
                    return methodName.equals(method.getName());
                }
            });
            method = MethodSearch.findMethod((String)methodName, (IOpenClass[])parTypes, (ICastFactory)this, (Iterable)internalselect);
        }
        return method;
    }

    protected synchronized void add(String namespace, String typeName, IOpenClass type) throws OpenLCompilationException {
        if (type instanceof CustomDynamicOpenClass) {
            CustomDynamicOpenClass customDynamicOpenClass = (CustomDynamicOpenClass)type;
            IOpenClass openClass = super.findType(namespace, typeName);
            if (openClass == null) {
                IOpenClass copyOfCustomType = customDynamicOpenClass.copy();
                this.getModule().addType(copyOfCustomType);
                super.add(namespace, typeName, copyOfCustomType);
            } else {
                customDynamicOpenClass.updateOpenClass(openClass);
            }
        } else {
            super.add(namespace, typeName, type);
        }
    }

    public IOpenClass findType(String namespace, String typeName) {
        String sprMethodName;
        IOpenMethod method;
        if (OpenLSystemProperties.isCustomSpreadsheetType(this.getExternalParams()) && typeName.startsWith("SpreadsheetResult") && typeName.length() > "SpreadsheetResult".length() && (method = this.preBinderMethods.get(sprMethodName = typeName.substring("SpreadsheetResult".length()))) != null) {
            RecursiveOpenMethodPreBinder openMethodBinder = (RecursiveOpenMethodPreBinder)method;
            if (openMethodBinder.isPreBinding()) {
                IOpenClass type = super.findType(namespace, typeName);
                if (type != null) {
                    return type;
                }
                throw new RecursiveMethodPreBindingException();
            }
            openMethodBinder.preBind();
            this.preBinderMethods.remove((IOpenMethodHeader)openMethodBinder.getHeader());
        }
        return super.findType(namespace, typeName);
    }

    public void addBinderMethod(OpenMethodHeader openMethodHeader, RecursiveOpenMethodPreBinder method) {
        this.preBinderMethods.put((IOpenMethodHeader)openMethodHeader, method);
    }

    public void preBindMethod(OpenMethodHeader openMethodHeader) {
        IOpenMethod method = this.preBinderMethods.get((IOpenMethodHeader)openMethodHeader);
        if (method != null) {
            RecursiveOpenMethodPreBinder openMethodBinder = (RecursiveOpenMethodPreBinder)method;
            openMethodBinder.preBind();
            this.preBinderMethods.remove((IOpenMethodHeader)openMethodBinder.getHeader());
        }
    }

    public static final class ModifyRuntimeContextMethod
    implements IOpenMethod {
        public static final String MODIFY_CONTEXT_METHOD_NAME = "modifyContext";

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            if (env.isContextManagingSupported()) {
                RulesRuntimeContextDelegator runtimeContext = new RulesRuntimeContextDelegator((IRulesRuntimeContext)env.getContext());
                runtimeContext.setValue((String)params[0], params[1]);
                env.pushContext((IRuntimeContext)runtimeContext);
            } else {
                LoggerFactory.getLogger(RulesModuleBindingContext.class).warn("Failed to modify runtime context. Runtime context does not support context modifications.");
            }
            return null;
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public String getName() {
            return MODIFY_CONTEXT_METHOD_NAME;
        }

        public String getDisplayName(int mode) {
            return MODIFY_CONTEXT_METHOD_NAME;
        }

        public boolean isStatic() {
            return false;
        }

        public IOpenClass getType() {
            return JavaOpenClass.VOID;
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenClass getDeclaringClass() {
            return null;
        }

        public IMethodSignature getSignature() {
            return new MethodSignature(new IParameterDeclaration[]{new ParameterDeclaration((IOpenClass)JavaOpenClass.STRING, "property"), new ParameterDeclaration((IOpenClass)JavaOpenClass.OBJECT, "value")});
        }

        public boolean isConstructor() {
            return false;
        }
    }

    public static final class SetRuntimeContextMethod
    implements IOpenMethod {
        public static final String SET_CONTEXT_METHOD_NAME = "setContext";

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            if (env.isContextManagingSupported()) {
                IRulesRuntimeContext runtimeContext = (IRulesRuntimeContext)params[0];
                env.pushContext((IRuntimeContext)runtimeContext);
            } else {
                LoggerFactory.getLogger(RulesModuleBindingContext.class).warn("Failed to set runtime context. Runtime context does not support context modifications.");
            }
            return null;
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public String getName() {
            return SET_CONTEXT_METHOD_NAME;
        }

        public String getDisplayName(int mode) {
            return SET_CONTEXT_METHOD_NAME;
        }

        public boolean isStatic() {
            return false;
        }

        public IOpenClass getType() {
            return JavaOpenClass.VOID;
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenClass getDeclaringClass() {
            return null;
        }

        public IMethodSignature getSignature() {
            return new MethodSignature(new IParameterDeclaration[]{new ParameterDeclaration((IOpenClass)JavaOpenClass.getOpenClass(IRulesRuntimeContext.class), "context")});
        }

        public boolean isConstructor() {
            return false;
        }
    }

    public static final class RestoreRuntimeContextMethod
    implements IOpenMethod {
        public static final String RESTORE_CONTEXT_METHOD_NAME = "restoreContext";

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            if (env.isContextManagingSupported()) {
                env.popContext();
            } else {
                LoggerFactory.getLogger(RulesModuleBindingContext.class).warn("Failed to restore runtime context. Runtime context does not support context modifications.");
            }
            return null;
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public String getName() {
            return RESTORE_CONTEXT_METHOD_NAME;
        }

        public String getDisplayName(int mode) {
            return RESTORE_CONTEXT_METHOD_NAME;
        }

        public boolean isStatic() {
            return false;
        }

        public IOpenClass getType() {
            return JavaOpenClass.VOID;
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenClass getDeclaringClass() {
            return null;
        }

        public IMethodSignature getSignature() {
            return IMethodSignature.VOID;
        }

        public boolean isConstructor() {
            return false;
        }
    }

    public static final class EmptyRuntimeContextMethod
    implements IOpenMethod {
        public static final String EMPTY_CONTEXT_METHOD_NAME = "emptyContext";

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            return RulesRuntimeContextFactory.buildRulesRuntimeContext();
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public String getName() {
            return EMPTY_CONTEXT_METHOD_NAME;
        }

        public String getDisplayName(int mode) {
            return EMPTY_CONTEXT_METHOD_NAME;
        }

        public boolean isStatic() {
            return false;
        }

        public IOpenClass getType() {
            return JavaOpenClass.getOpenClass(IRulesRuntimeContext.class);
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenClass getDeclaringClass() {
            return null;
        }

        public IMethodSignature getSignature() {
            return IMethodSignature.VOID;
        }

        public boolean isConstructor() {
            return false;
        }
    }

    public static final class CurrentRuntimeContextMethod
    implements IOpenMethod {
        public static final String CURRENT_CONTEXT_METHOD_NAME = "getContext";

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            IRulesRuntimeContext context = (IRulesRuntimeContext)env.getContext();
            try {
                return context.clone();
            }
            catch (CloneNotSupportedException e) {
                LoggerFactory.getLogger(RulesModuleBindingContext.class).warn("Failed to clone runtime context. Runtime context managing may work incorrectly.", (Throwable)e);
                return context;
            }
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public String getName() {
            return CURRENT_CONTEXT_METHOD_NAME;
        }

        public String getDisplayName(int mode) {
            return CURRENT_CONTEXT_METHOD_NAME;
        }

        public boolean isStatic() {
            return false;
        }

        public IOpenClass getType() {
            return JavaOpenClass.getOpenClass(IRulesRuntimeContext.class);
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenClass getDeclaringClass() {
            return null;
        }

        public IMethodSignature getSignature() {
            return IMethodSignature.VOID;
        }

        public boolean isConstructor() {
            return false;
        }
    }
}

