/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.openl.rules.calc.SpreadsheetResultOpenClass;
import org.openl.rules.calc.SpreadsheetResultRootDictionaryContext;
import org.openl.rules.helpers.ITableAdaptor;
import org.openl.rules.helpers.TablePrinter;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.Point;
import org.openl.types.java.CustomJavaOpenClass;

@XmlRootElement
@CustomJavaOpenClass(type=SpreadsheetResultOpenClass.class, variableInContextFinder=SpreadsheetResultRootDictionaryContext.class)
public class SpreadsheetResult
implements Serializable {
    private static final long serialVersionUID = 8704762477153429384L;
    private Object[][] results;
    private int height;
    private int width;
    private String[] columnNames;
    private String[] rowNames;
    private String[] columnTitles;
    private String[] rowTitles;
    private Map<String, Point> fieldsCoordinates = new HashMap<String, Point>();
    private transient ILogicalTable logicalTable;

    public SpreadsheetResult() {
    }

    public SpreadsheetResult(int height, int width) {
        this.height = height;
        this.width = width;
        this.columnNames = new String[height];
        this.rowNames = new String[width];
        this.results = new Object[height][width];
    }

    public SpreadsheetResult(Object[][] results, String[] rowNames, String[] columnNames, String[] rowTitles, String[] columnTitles, Map<String, Point> fieldsCoordinates) {
        this.columnNames = columnNames;
        this.rowNames = rowNames;
        this.columnTitles = columnTitles;
        this.rowTitles = rowTitles;
        this.height = rowNames.length;
        this.width = columnNames.length;
        this.results = (Object[][])results.clone();
        this.fieldsCoordinates = fieldsCoordinates;
    }

    @Deprecated
    public int height() {
        return this.getHeight();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Object[][] getResults() {
        return (Object[][])this.results.clone();
    }

    public void setResults(Object[][] results) {
        this.results = (Object[][])results.clone();
    }

    @Deprecated
    public int width() {
        return this.getWidth();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String[] getColumnNames() {
        if (this.columnNames == null) {
            return null;
        }
        return (String[])this.columnNames.clone();
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = (String[])columnNames.clone();
    }

    public String[] getRowNames() {
        if (this.columnNames == null) {
            return null;
        }
        return (String[])this.rowNames.clone();
    }

    public void setRowNames(String[] rowNames) {
        this.rowNames = (String[])rowNames.clone();
    }

    public Object getValue(int row, int column) {
        return this.results[row][column];
    }

    public String[] getRowTitles() {
        return this.rowTitles;
    }

    public void setRowTitles(String[] rowTitles) {
        this.rowTitles = rowTitles;
    }

    public String[] getColumnTitles() {
        return this.columnTitles;
    }

    public void setColumnTitles(String[] columnTitles) {
        this.columnTitles = columnTitles;
    }

    public void setFieldValue(String name, Object value) {
        Point fieldCoordinates = this.fieldsCoordinates.get(name);
        if (fieldCoordinates != null) {
            this.setValue(fieldCoordinates.getRow(), fieldCoordinates.getColumn(), value);
        }
    }

    protected void setValue(int row, int column, Object value) {
        this.results[row][column] = value;
    }

    public String getColumnName(int column) {
        if (this.columnNames != null) {
            return this.columnNames[column];
        }
        return "DefaultColumnName" + column;
    }

    public String getRowName(int row) {
        if (this.rowNames != null) {
            return this.rowNames[row];
        }
        return "DefaultRowName" + row;
    }

    public String getColumnTitle(int column) {
        if (this.columnTitles != null) {
            return this.columnTitles[column];
        }
        return "DefaultColumnTitle" + column;
    }

    public String getRowTitle(int row) {
        if (this.rowTitles != null) {
            return this.rowTitles[row];
        }
        return "DefaultRowTitle" + row;
    }

    public Map<String, Point> getFieldsCoordinates() {
        return new HashMap<String, Point>(this.fieldsCoordinates);
    }

    protected void addFieldCoordinates(String field, Point coord) {
        this.fieldsCoordinates.put(field, coord);
    }

    public void setFieldsCoordinates(Map<String, Point> fieldsCoordinates) {
        this.fieldsCoordinates = new HashMap<String, Point>(fieldsCoordinates);
    }

    @XmlTransient
    public ILogicalTable getLogicalTable() {
        return this.logicalTable;
    }

    public void setLogicalTable(ILogicalTable logicalTable) {
        this.logicalTable = logicalTable;
    }

    public Object getFieldValue(String name) {
        Point fieldCoordinates = this.fieldsCoordinates.get(name);
        if (fieldCoordinates != null) {
            return this.getValue(fieldCoordinates.getRow(), fieldCoordinates.getColumn());
        }
        return null;
    }

    public boolean hasField(String name) {
        return this.fieldsCoordinates.get(name) != null;
    }

    public ITableAdaptor makeTableAdaptor() {
        return new ITableAdaptor(){
            private static final int MAX_WIDTH = 10;
            private static final int MAX_HEIGHT = 10;

            @Override
            public int width(int row) {
                return Math.min(10, SpreadsheetResult.this.getWidth() + 1);
            }

            @Override
            public int maxWidth() {
                return Math.min(10, SpreadsheetResult.this.getWidth() + 1);
            }

            @Override
            public int height() {
                return Math.min(10, SpreadsheetResult.this.getHeight() + 1);
            }

            @Override
            public Object get(int col, int row) {
                if (col == 0 && row == 0) {
                    return "-X-";
                }
                if (col == 9 && 10 <= SpreadsheetResult.this.getWidth() || row == 9 && 10 <= SpreadsheetResult.this.getHeight()) {
                    return "... TRUNCATED ...";
                }
                if (col == 0) {
                    return SpreadsheetResult.this.getRowName(row - 1);
                }
                if (row == 0) {
                    return SpreadsheetResult.this.getColumnName(col - 1);
                }
                return SpreadsheetResult.this.getValue(row - 1, col - 1);
            }
        };
    }

    public String printAsTable() {
        return new TablePrinter(this.makeTableAdaptor(), null, " | ").print();
    }

    public String toString() {
        try {
            return this.printAsTable();
        }
        catch (Exception e) {
            return super.toString();
        }
    }
}

