/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc.element;

import java.util.ArrayList;
import java.util.Collections;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.NodeUsage;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.rules.calc.element.SpreadsheetCellType;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.ICell;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.Invokable;
import org.openl.types.NullOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.NumberUtils;
import org.openl.vm.IRuntimeEnv;

public class SpreadsheetCell
implements Invokable {
    private int rowIndex;
    private int columnIndex;
    private ICell sourceCell;
    private SpreadsheetCellType spreadsheetCellType;
    private Object value;
    private IOpenClass type;
    private IOpenMethod method;

    public SpreadsheetCell(int rowIndex, int columnIndex, ICell sourceCell, SpreadsheetCellType spreadsheetCellType) {
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.sourceCell = sourceCell;
        this.spreadsheetCellType = spreadsheetCellType;
    }

    public ICell getSourceCell() {
        return this.sourceCell;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public SpreadsheetCellType getSpreadsheetCellType() {
        return this.spreadsheetCellType;
    }

    public IOpenMethod getMethod() {
        return this.method;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public IOpenClass getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.spreadsheetCellType == SpreadsheetCellType.EMPTY;
    }

    public boolean isMethodCell() {
        return this.spreadsheetCellType == SpreadsheetCellType.METHOD;
    }

    public boolean isValueCell() {
        return this.spreadsheetCellType == SpreadsheetCellType.VALUE;
    }

    public void setMethod(IOpenMethod method) {
        this.method = method;
    }

    public void setType(IOpenClass type) {
        String formattedValue;
        if (type == null) {
            return;
        }
        if (type.equals(NullOpenClass.the)) {
            type = JavaOpenClass.OBJECT;
        } else if (type == JavaOpenClass.VOID) {
            type = JavaOpenClass.getOpenClass(Void.class);
        } else if (type.getInstanceClass() != null && type.getInstanceClass().isPrimitive()) {
            Class wrapper = NumberUtils.getWrapperType((String)type.getInstanceClass().getName());
            type = JavaOpenClass.getOpenClass((Class)wrapper);
        }
        this.type = type;
        if (this.sourceCell != null && (formattedValue = this.sourceCell.getFormattedValue()).startsWith("=")) {
            CellMetaInfo metaInfo = this.sourceCell.getMetaInfo();
            if (metaInfo == null) {
                metaInfo = new CellMetaInfo(CellMetaInfo.Type.DT_CA_CODE, null, (IOpenClass)JavaOpenClass.STRING, false, Collections.emptyList());
            }
            ArrayList<? extends NodeUsage> nodeUsages = new ArrayList<NodeUsage>();
            String description = "Cell type: " + type.getDisplayName(0);
            int from = formattedValue.indexOf(61);
            nodeUsages.add(new SimpleNodeUsage(from, from, description, null, NodeType.OTHER));
            nodeUsages.addAll(metaInfo.getUsedNodes());
            metaInfo.setUsedNodes(nodeUsages);
            this.sourceCell.setMetaInfo(metaInfo);
        }
    }

    public void setValue(Object value) {
        if (value != null) {
            if (value instanceof IOpenMethod) {
                this.method = (IOpenMethod)value;
            } else {
                this.value = value;
            }
        }
    }

    public Object invoke(Object spreadsheetResult, Object[] params, IRuntimeEnv env) {
        if (this.isValueCell()) {
            Object value = this.getValue();
            return value;
        }
        if (this.isMethodCell()) {
            return this.getMethod().invoke(spreadsheetResult, params, env);
        }
        return null;
    }

    public String toString() {
        return "R" + this.getRowIndex() + "C" + this.getColumnIndex();
    }
}

