/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc.result;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetResultCalculator;
import org.openl.rules.calc.element.SpreadsheetCellField;
import org.openl.rules.calc.result.IResultBuilder;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.Point;
import org.openl.types.IOpenField;

public class DefaultResultBuilder
implements IResultBuilder {
    @Override
    public Object makeResult(SpreadsheetResultCalculator result) {
        Object[][] resultArray = this.getResultArray(result);
        String[] rowNames = this.getRowNames(result);
        String[] columnNames = this.getColumnNames(result);
        String[] rowTitles = this.getRowTitles(result);
        String[] columnTitles = this.getColumnTitles(result);
        Map<String, Point> fieldsCoordinates = result.getSpreadsheet().getFieldsCoordinates();
        Constructor<?> constructor = null;
        try {
            constructor = result.getSpreadsheet().getResultConstructor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SpreadsheetResult spreadsheetBean = null;
        try {
            spreadsheetBean = (SpreadsheetResult)constructor.newInstance(new Object[]{resultArray, rowNames, columnNames, rowTitles, columnTitles, fieldsCoordinates});
        }
        catch (Exception exception) {
            // empty catch block
        }
        ILogicalTable table = this.getSpreadsheetTable(result);
        spreadsheetBean.setLogicalTable(table);
        return spreadsheetBean;
    }

    private ILogicalTable getSpreadsheetTable(SpreadsheetResultCalculator result) {
        TableSyntaxNode tsn = result.getSpreadsheet().getSyntaxNode();
        ILogicalTable table = null;
        if (tsn != null) {
            table = tsn.getTableBody();
        }
        return table;
    }

    private String[] getColumnNames(SpreadsheetResultCalculator result) {
        int width = result.width();
        String[] columnNames = new String[width];
        for (int col = 0; col < width; ++col) {
            columnNames[col] = result.getColumnName(col);
        }
        return columnNames;
    }

    private String[] getRowNames(SpreadsheetResultCalculator result) {
        int height = result.height();
        String[] rowNames = new String[height];
        for (int row = 0; row < height; ++row) {
            rowNames[row] = result.getRowName(row);
        }
        return rowNames;
    }

    private String[] getColumnTitles(SpreadsheetResultCalculator result) {
        int width = result.width();
        String[] columnTitles = new String[width];
        for (int col = 0; col < width; ++col) {
            columnTitles[col] = result.getColumnTitle(col);
        }
        return columnTitles;
    }

    private String[] getRowTitles(SpreadsheetResultCalculator result) {
        int height = result.height();
        String[] rowTitles = new String[height];
        for (int row = 0; row < height; ++row) {
            rowTitles[row] = result.getRowTitle(row);
        }
        return rowTitles;
    }

    public static Map<String, Point> getFieldsCoordinates(Map<String, IOpenField> spreadsheetfields) {
        HashMap<String, Point> fieldsCoordinates = new HashMap<String, Point>();
        for (Map.Entry<String, IOpenField> fieldEntry : spreadsheetfields.entrySet()) {
            Point fieldCoordinates = DefaultResultBuilder.getRelativeSpreadsheetFieldCoordinates(fieldEntry.getValue());
            if (fieldCoordinates == null) continue;
            fieldsCoordinates.put(fieldEntry.getKey(), fieldCoordinates);
        }
        return fieldsCoordinates;
    }

    public static Point getRelativeSpreadsheetFieldCoordinates(IOpenField field) {
        if (field instanceof SpreadsheetCellField) {
            SpreadsheetCellField cellField = (SpreadsheetCellField)field;
            return cellField.getRelativeCoordinates();
        }
        return null;
    }

    public static Point getAbsoluteSpreadsheetFieldCoordinates(IOpenField field) {
        if (field instanceof SpreadsheetCellField) {
            SpreadsheetCellField cellField = (SpreadsheetCellField)field;
            return cellField.getAbsoluteCoordinates();
        }
        return null;
    }

    public static Map<String, Point> getAbsoluteSpreadsheetFieldCoordinates(SpreadsheetResult spreadsheetResult) {
        HashMap<String, Point> absoluteCoordinates = new HashMap<String, Point>();
        IGridTable sourceTable = spreadsheetResult.getLogicalTable().getSource();
        Map<String, Point> relativeCoordinates = spreadsheetResult.getFieldsCoordinates();
        for (Map.Entry<String, Point> fieldEntry : relativeCoordinates.entrySet()) {
            Point relative = fieldEntry.getValue();
            int column = DefaultResultBuilder.getColumn(sourceTable, relative.getColumn());
            int row = DefaultResultBuilder.getRow(sourceTable, relative.getRow());
            ICell cell = sourceTable.getCell(column, row);
            Point absolute = new Point(cell.getAbsoluteColumn(), cell.getAbsoluteRow());
            absoluteCoordinates.put(fieldEntry.getKey(), absolute);
        }
        return absoluteCoordinates;
    }

    private static int getColumn(IGridTable spreadsheet, int columnFieldNumber) {
        int column = 0;
        for (int i = 0; i <= columnFieldNumber; ++i) {
            column += spreadsheet.getCell(i, 0).getWidth();
        }
        return column;
    }

    private static int getRow(IGridTable spreadsheet, int rowFieldNumber) {
        int row = 0;
        for (int i = 0; i <= rowFieldNumber; ++i) {
            row += spreadsheet.getCell(0, i).getHeight();
        }
        return row;
    }

    private Object[][] getResultArray(SpreadsheetResultCalculator result) {
        int height = result.height();
        int width = result.width();
        Object[][] resultArray = new Object[height][width];
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                resultArray[row][col] = result.getValue(row, col);
            }
        }
        return resultArray;
    }
}

