/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.util.HashMap;
import java.util.Map;
import org.openl.IOpenBinder;
import org.openl.OpenL;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.cast.JavaNoCast;
import org.openl.rules.enumeration.CaProvincesEnum;
import org.openl.rules.enumeration.CaRegionsEnum;
import org.openl.rules.enumeration.CountriesEnum;
import org.openl.rules.enumeration.CurrenciesEnum;
import org.openl.rules.enumeration.LanguagesEnum;
import org.openl.rules.enumeration.RegionsEnum;
import org.openl.rules.enumeration.UsRegionsEnum;
import org.openl.rules.enumeration.UsStatesEnum;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;

public class ObjectToDataOpenCastConvertor {
    private static Map<ClassCastPair, IOpenCast> convertors = new HashMap<ClassCastPair, IOpenCast>();

    public static synchronized IOpenCast getConvertor(Class<?> toClass, Class<?> fromClass) {
        if (toClass == fromClass) {
            return new JavaNoCast();
        }
        ClassCastPair pair = new ClassCastPair(fromClass, toClass);
        if (convertors.containsKey(pair)) {
            return convertors.get(pair);
        }
        IOpenBinder binder = OpenL.getInstance((String)"org.openl.rules.java").getBinder();
        IOpenCast openCast = binder.getCastFactory().getCast((IOpenClass)JavaOpenClass.getOpenClass(fromClass), (IOpenClass)JavaOpenClass.getOpenClass(toClass));
        convertors.put(pair, openCast);
        return openCast;
    }

    static {
        EnumToStringOpenCast enumToStringOpenCast = new EnumToStringOpenCast();
        convertors.put(new ClassCastPair(UsStatesEnum.class, String.class), enumToStringOpenCast);
        convertors.put(new ClassCastPair(CountriesEnum.class, String.class), enumToStringOpenCast);
        convertors.put(new ClassCastPair(UsRegionsEnum.class, String.class), enumToStringOpenCast);
        convertors.put(new ClassCastPair(CurrenciesEnum.class, String.class), enumToStringOpenCast);
        convertors.put(new ClassCastPair(LanguagesEnum.class, String.class), enumToStringOpenCast);
        convertors.put(new ClassCastPair(RegionsEnum.class, String.class), enumToStringOpenCast);
        convertors.put(new ClassCastPair(CaProvincesEnum.class, String.class), enumToStringOpenCast);
        convertors.put(new ClassCastPair(CaRegionsEnum.class, String.class), enumToStringOpenCast);
        convertors.put(new ClassCastPair(String.class, UsStatesEnum.class), new StringToEnumOpenCast(UsStatesEnum.class));
        convertors.put(new ClassCastPair(String.class, CountriesEnum.class), new StringToEnumOpenCast(CountriesEnum.class));
        convertors.put(new ClassCastPair(String.class, UsRegionsEnum.class), new StringToEnumOpenCast(UsRegionsEnum.class));
        convertors.put(new ClassCastPair(String.class, CurrenciesEnum.class), new StringToEnumOpenCast(CurrenciesEnum.class));
        convertors.put(new ClassCastPair(String.class, LanguagesEnum.class), new StringToEnumOpenCast(LanguagesEnum.class));
        convertors.put(new ClassCastPair(String.class, RegionsEnum.class), new StringToEnumOpenCast(RegionsEnum.class));
        convertors.put(new ClassCastPair(String.class, CaProvincesEnum.class), new StringToEnumOpenCast(CaProvincesEnum.class));
        convertors.put(new ClassCastPair(String.class, CaRegionsEnum.class), new StringToEnumOpenCast(CaRegionsEnum.class));
    }

    public static class EnumToStringOpenCast
    implements IOpenCast {
        public Object convert(Object from) {
            return from.toString();
        }

        public int getDistance(IOpenClass from, IOpenClass to) {
            return 13;
        }

        public boolean isImplicit() {
            return false;
        }
    }

    public static class StringToEnumOpenCast
    implements IOpenCast {
        private Class enumType;

        public StringToEnumOpenCast(Class<?> enumType) {
            this.enumType = enumType;
        }

        public Object convert(Object from) {
            return Enum.valueOf(this.enumType, (String)from);
        }

        public int getDistance(IOpenClass from, IOpenClass to) {
            return 12;
        }

        public boolean isImplicit() {
            return false;
        }
    }

    public static class ClassCastPair {
        private Class<?> from;
        private Class<?> to;

        public ClassCastPair(Class<?> from, Class<?> to) {
            this.from = from;
            this.to = to;
        }

        public Class<?> getFrom() {
            return this.from;
        }

        public Class<?> getTo() {
            return this.to;
        }

        public int hashCode() {
            return this.to.hashCode() + this.from.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassCastPair)) {
                return false;
            }
            ClassCastPair pair = (ClassCastPair)obj;
            return this.from == pair.from && this.to == pair.to;
        }
    }
}

