/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.Locale;
import org.openl.rules.convertor.IString2DataConvertor;

abstract class String2NumberConverter<T extends Number>
implements IString2DataConvertor<T> {
    String2NumberConverter() {
    }

    @Override
    public String format(T data, String format) {
        if (data == null) {
            return null;
        }
        DecimalFormat df = this.getFormatter(format);
        return df.format(data);
    }

    @Override
    public T parse(String data, String format) {
        if (data == null) {
            return null;
        }
        if (data.length() == 0) {
            throw new NumberFormatException("Cannot convert an empty String to numeric type");
        }
        if ("%".equals(data)) {
            throw new NumberFormatException("Cannot convert \"%\" to numeric type");
        }
        DecimalFormat df = this.getFormatter(format);
        if (data.endsWith("%")) {
            df.setMultiplier(100);
            data = data.substring(0, data.length() - 1);
        }
        ParsePosition position = new ParsePosition(0);
        Number number = df.parse(data, position);
        int index = position.getIndex();
        if (index < data.length()) {
            throw new NumberFormatException("Cannot convert \"" + data + "\" to numeric type");
        }
        return this.convert(number, data);
    }

    abstract T convert(Number var1, String var2);

    DecimalFormat getFormatter(String format) {
        DecimalFormat df;
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        symbols.setInfinity("Infinity");
        symbols.setNaN("NaN");
        if (format != null) {
            df = new DecimalFormat(format, symbols);
        } else {
            df = new DecimalFormat("", symbols);
            df.setGroupingUsed(false);
            df.setMinimumIntegerDigits(1);
        }
        return df;
    }
}

