/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.core.ce;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import org.openl.rules.core.ce.Runnable;
import org.openl.rules.tbasic.runtime.TBasicContextHolderEnv;
import org.openl.rules.vm.SimpleRulesRuntimeEnv;
import org.openl.rules.vm.ce.SimpleRulesRuntimeEnvMT;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.Tracer;

public final class ServiceMT {
    private ForkJoinPool forkJoinPool = new ForkJoinPool();

    public static ServiceMT getInstance() {
        return ServiceMTHolder.INSTANCE;
    }

    public void execute(IRuntimeEnv env, Runnable runnable) {
        if (Tracer.isEnabled()) {
            runnable.run(env);
            return;
        }
        SimpleRulesRuntimeEnv simpleRulesRuntimeEnv = this.extractSimpleRulesRuntimeEnv(env);
        RunnableRecursiveAction action = new RunnableRecursiveAction(runnable, simpleRulesRuntimeEnv, Thread.currentThread().getContextClassLoader());
        simpleRulesRuntimeEnv.pushAction(action);
        if (simpleRulesRuntimeEnv instanceof SimpleRulesRuntimeEnvMT) {
            action.fork();
        } else {
            this.forkJoinPool.execute(action);
        }
    }

    public void execute(ForkJoinTask<?> task) {
        this.forkJoinPool.execute(task);
    }

    public void executeAll(ForkJoinTask<?> ... tasks) {
        for (ForkJoinTask<?> task : tasks) {
            this.forkJoinPool.execute(task);
        }
    }

    public void join(IRuntimeEnv env) {
        SimpleRulesRuntimeEnv simpleRulesRuntimeEnv = this.extractSimpleRulesRuntimeEnv(env);
        try {
            while (simpleRulesRuntimeEnv.joinActionIfExists()) {
            }
        }
        finally {
            while (simpleRulesRuntimeEnv.cancelActionIfExists()) {
            }
        }
    }

    private SimpleRulesRuntimeEnv extractSimpleRulesRuntimeEnv(IRuntimeEnv env) {
        if (env instanceof TBasicContextHolderEnv) {
            IRuntimeEnv env1 = ((TBasicContextHolderEnv)env).getEnv();
            if (env1 instanceof TBasicContextHolderEnv) {
                return this.extractSimpleRulesRuntimeEnv(env1);
            }
            return (SimpleRulesRuntimeEnv)env1;
        }
        return (SimpleRulesRuntimeEnv)env;
    }

    private static class RunnableRecursiveAction
    extends RecursiveAction {
        private static final long serialVersionUID = -6827837658658403954L;
        private Runnable runnable;
        private SimpleRulesRuntimeEnv env;
        private ClassLoader classLoader;

        private RunnableRecursiveAction(Runnable runnable, SimpleRulesRuntimeEnv env, ClassLoader classLoader) {
            this.runnable = runnable;
            this.env = env;
            this.classLoader = classLoader;
        }

        @Override
        protected void compute() {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                if (this.env instanceof SimpleRulesRuntimeEnvMT) {
                    this.runnable.run((IRuntimeEnv)((SimpleRulesRuntimeEnv)this.env.clone()));
                } else {
                    this.runnable.run((IRuntimeEnv)new SimpleRulesRuntimeEnvMT(this.env));
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    private static class ServiceMTHolder {
        private static final ServiceMT INSTANCE = new ServiceMT();

        private ServiceMTHolder() {
        }
    }
}

