/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import org.openl.OpenL;
import org.openl.meta.StringValue;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.data.DatatypeArrayMultiRowElementContext;
import org.openl.rules.data.DatatypeArrayMultiRowElementField;
import org.openl.rules.data.FieldChain;
import org.openl.rules.data.ITable;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.vm.IRuntimeEnv;

public class ColumnDescriptor {
    private IOpenField field;
    private StringValue displayValue;
    private OpenL openl;
    private boolean valuesAnArray = false;
    private boolean supportMultirows = false;
    private boolean constructor = false;
    private Map<String, Integer> uniqueIndex = null;
    private Map<String, Integer> formattedUniqueIndex = null;
    private IdentifierNode[] fieldChainTokens;
    private static final Object PREV_RES_EMPTY = new Object();

    public ColumnDescriptor(IOpenField field, StringValue displayValue, OpenL openl, boolean constructor, IdentifierNode[] fieldChainTokens) {
        this.field = field;
        this.displayValue = displayValue;
        this.openl = openl;
        this.constructor = constructor;
        this.fieldChainTokens = fieldChainTokens;
        if (field != null) {
            this.valuesAnArray = ColumnDescriptor.isValuesAnArray(field.getType());
            if (field instanceof FieldChain) {
                FieldChain fieldChain = (FieldChain)field;
                for (IOpenField f : fieldChain.getFields()) {
                    if (!(f instanceof DatatypeArrayMultiRowElementField)) continue;
                    this.supportMultirows = true;
                }
            }
        }
    }

    protected IRuntimeEnv getRuntimeEnv() {
        return this.openl.getVm().getRuntimeEnv();
    }

    protected static boolean isValuesAnArray(IOpenClass paramType) {
        return paramType.getAggregateInfo().isAggregate(paramType);
    }

    protected IOpenField getField() {
        return this.field;
    }

    public Object getColumnValue(Object target) {
        return this.field == null ? target : this.field.get(target, this.getRuntimeEnv());
    }

    public String getDisplayName() {
        return this.displayValue.getValue();
    }

    public Object getLiteral(IOpenClass paramType, ILogicalTable valuesTable, OpenlToolAdaptor ota) throws SyntaxNodeException {
        Object resultLiteral = null;
        boolean valuesAnArray = ColumnDescriptor.isValuesAnArray(paramType);
        valuesTable = LogicalTableHelper.make1ColumnTable(valuesTable);
        if (!valuesAnArray) {
            resultLiteral = RuleRowHelper.loadSingleParam(paramType, this.field == null ? "constructor" : this.field.getName(), null, valuesTable, ota);
        } else {
            paramType = paramType.getAggregateInfo().getComponentType(paramType);
            resultLiteral = valuesTable.getHeight() == 1 && valuesTable.getWidth() == 1 ? RuleRowHelper.loadCommaSeparatedParam(paramType, this.field == null ? "constructor" : this.field.getName(), null, valuesTable, ota) : this.loadMultiRowArray(valuesTable, ota, paramType);
        }
        return resultLiteral;
    }

    public String getName() {
        return this.field == null ? "this" : this.field.getName();
    }

    public IOpenClass getType() {
        return this.field.getType();
    }

    public synchronized Map<String, Integer> getUniqueIndex(ITable table, int idx) throws SyntaxNodeException {
        if (this.uniqueIndex == null) {
            this.uniqueIndex = table.makeUniqueIndex(idx);
        }
        return this.uniqueIndex;
    }

    public synchronized Map<String, Integer> getFormattedUniqueIndex(ITable table, int idx) throws SyntaxNodeException {
        if (this.formattedUniqueIndex == null) {
            this.formattedUniqueIndex = table.makeFormattedUniqueIndex(idx);
        }
        return this.formattedUniqueIndex;
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    public IdentifierNode[] getFieldChainTokens() {
        return this.fieldChainTokens;
    }

    public Object populateLiteral(Object literal, ILogicalTable valuesTable, OpenlToolAdaptor toolAdapter, IRuntimeEnv env) throws SyntaxNodeException {
        if (this.field != null) {
            IOpenClass paramType = this.field.getType();
            if (this.valuesAnArray) {
                paramType = paramType.getAggregateInfo().getComponentType(paramType);
            }
            valuesTable = LogicalTableHelper.make1ColumnTable(valuesTable);
            if (!this.valuesAnArray) {
                env.pushThis(literal);
                if (this.supportMultirows) {
                    this.processWithMultiRowsSupport(literal, valuesTable, toolAdapter, env, paramType, this.valuesAnArray);
                } else {
                    Object res = RuleRowHelper.loadSingleParam(paramType, this.field == null ? "constructor" : this.field.getName(), null, (ILogicalTable)LogicalTableHelper.logicalTable((IGridTable)valuesTable.getSource().getSubtable(0, 0, 1, 1)).getSubtable(0, 0, 1, 1), toolAdapter);
                    if (res != null) {
                        this.field.set(literal, res, env);
                    }
                }
                return env.popThis();
            }
            env.pushThis(literal);
            Object arrayValues = null;
            if (this.supportMultirows) {
                this.processWithMultiRowsSupport(literal, valuesTable, toolAdapter, env, paramType, this.valuesAnArray);
            } else {
                arrayValues = this.getArrayValues(valuesTable, toolAdapter, paramType);
                this.field.set(literal, arrayValues, this.getRuntimeEnv());
            }
            return env.popThis();
        }
        return literal;
    }

    private void processWithMultiRowsSupport(Object literal, ILogicalTable valuesTable, OpenlToolAdaptor toolAdapter, IRuntimeEnv env, IOpenClass paramType, boolean valuesAnArray) throws SyntaxNodeException {
        DatatypeArrayMultiRowElementContext datatypeArrayMultiRowElementContext = (DatatypeArrayMultiRowElementContext)env.getLocalFrame()[0];
        Object prevRes = PREV_RES_EMPTY;
        for (int i = 0; i < valuesTable.getSource().getHeight(); ++i) {
            datatypeArrayMultiRowElementContext.setRow(i);
            Object res = null;
            ILogicalTable logicalTable = (ILogicalTable)LogicalTableHelper.logicalTable((IGridTable)valuesTable.getSource().getSubtable(0, i, 1, i + 1)).getSubtable(0, 0, 1, 1);
            res = valuesAnArray ? this.getArrayValues(logicalTable, toolAdapter, paramType) : RuleRowHelper.loadSingleParam(paramType, this.field == null ? "constructor" : this.field.getName(), null, logicalTable, toolAdapter);
            if (prevRes == null && res == null || prevRes != null && prevRes.equals(res)) {
                datatypeArrayMultiRowElementContext.setRowValueIsTheSameAsPrevious(true);
            } else {
                datatypeArrayMultiRowElementContext.setRowValueIsTheSameAsPrevious(false);
            }
            if (res != null || PREV_RES_EMPTY == prevRes) {
                this.field.set(literal, res, env);
            } else {
                this.field.get(literal, env);
            }
            prevRes = res;
        }
    }

    public boolean isReference() {
        return false;
    }

    private Object getArrayValues(ILogicalTable valuesTable, OpenlToolAdaptor ota, IOpenClass paramType) throws SyntaxNodeException {
        if (valuesTable.getHeight() == 1 && valuesTable.getWidth() == 1) {
            return RuleRowHelper.loadCommaSeparatedParam(paramType, this.field.getName(), null, (ILogicalTable)valuesTable.getRow(0), ota);
        }
        return this.loadMultiRowArray(valuesTable, ota, paramType);
    }

    private Object loadMultiRowArray(ILogicalTable logicalTable, OpenlToolAdaptor openlAdaptor, IOpenClass paramType) throws SyntaxNodeException {
        int valuesTableHeight = RuleRowHelper.calculateHeight(logicalTable);
        ArrayList<Object> values = new ArrayList<Object>(valuesTableHeight);
        for (int i = 0; i < valuesTableHeight; ++i) {
            Object res = RuleRowHelper.loadSingleParam(paramType, this.field == null ? "constructor" : this.field.getName(), null, (ILogicalTable)logicalTable.getRow(i), openlAdaptor);
            if (res == null) {
                res = paramType.nullObject();
            }
            values.add(res);
        }
        Object arrayValues = paramType.getAggregateInfo().makeIndexedAggregate(paramType, new int[]{values.size()});
        for (int i = 0; i < values.size(); ++i) {
            Array.set(arrayValues, i, values.get(i));
        }
        return arrayValues;
    }

    public void setCellMetaInfo(ILogicalTable cell) {
        if (this.field != null) {
            IOpenClass paramType = this.field.getType();
            String paramName = this.field.getName();
            if (this.valuesAnArray) {
                paramType = paramType.getAggregateInfo().getComponentType(paramType);
            }
            if (cell.getHeight() == 1 && cell.getWidth() == 1) {
                RuleRowHelper.setCellMetaInfo(cell, paramName, paramType, this.valuesAnArray);
            } else {
                cell = LogicalTableHelper.make1ColumnTable(cell);
                int valuesTableHeight = RuleRowHelper.calculateHeight(cell);
                for (int i = 0; i < valuesTableHeight; ++i) {
                    RuleRowHelper.setCellMetaInfo((ILogicalTable)cell.getRow(i), paramName, paramType, false);
                }
            }
        }
    }

    public boolean isSupportMultirows() {
        return this.supportMultirows;
    }

    public void setSupportMultirows(boolean supportMultirows) {
        this.supportMultirows = supportMultirows;
    }
}

